% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_caim_raw.R
\name{read_caim_raw}
\alias{read_caim_raw}
\title{Read a canopy image from a raw file}
\usage{
read_caim_raw(
  path = NULL,
  z = NULL,
  a = NULL,
  zenith_colrow = NULL,
  radius = 700,
  rmax = 100,
  k = 1,
  p = 1,
  only_blue = FALSE,
  offset_value = NULL
)
}
\arguments{
\item{path}{Character vector of length one.Path to a raw file, including file
extension.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{zenith_colrow}{Numeric vector of length two. Raster coordinates of the
zenith. See \code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}}.}

\item{radius}{Numeric integer of length one. Radius of the reprojected
hemispherical image (i.e., the output).}

\item{rmax}{Numeric vector of length one. Maximum radius where to search for
\emph{knn}. Increase this value if pixels with value \code{0} or
\code{FALSE} appears where other values are expected.}

\item{k}{Numeric vector of length one. Number of k-nearest neighbors.}

\item{p}{Numeric vector of length one. Power for inverse-distance weighting.}

\item{only_blue}{Logical vector of length one. If \code{TRUE}, only values from
the blue or cyan wavelength will be processed.}

\item{offset_value}{numeric vector. This values will replace the
\code{black_level_per_channel} metadata obtained with \code{rawpy}.}
}
\value{
An object from class \linkS4class{SpatRaster}. Single-layer raster if
\code{only_blue} is equal to \code{TRUE}. Otherwise, a raster with as many layers as
there are distinct colors in the Color Filter Array. Layer names are taken
from the color description metadata.
}
\description{
Function that complements \code{\link[=read_caim]{read_caim()}}
}
\details{
This function facilitates the integration of the \code{rawpy} Python package into
the R environment via the \code{reticulate} package. This integration allows
\code{rcaiman} to access and pre-process raw data.

Here is a step-by-step guide to assist users in setting up the environment
for efficient processing:
\subsection{Check Python Accessibility:}{

To ensure that R can access a Python installation, run the following test:

\if{html}{\out{<div class="sourceCode">}}\preformatted{reticulate::py_eval("1+1")

}\if{html}{\out{</div>}}

If R can access Python successfully, you will see \code{2} in the console. If not,
you will receive instructions on how to install Python.
}

\subsection{Create a Virtual Environment:}{

After passing the Python accessibility test, create a virtual environment
using the following command:

\if{html}{\out{<div class="sourceCode">}}\preformatted{reticulate::virtualenv_create()

}\if{html}{\out{</div>}}
}

\subsection{Install \code{rawpy}:}{

Install the rawpy package within the virtual environment:

\if{html}{\out{<div class="sourceCode">}}\preformatted{reticulate::py_install("rawpy")

}\if{html}{\out{</div>}}
}

\subsection{For RStudio Users:}{

If you are an RStudio user who works with projects, you will need a
\emph{.Renviron} file in the root of each project. To create a \emph{.Renviron} file,
follow these steps:
\itemize{
\item Create a "New Blank File" named ".Renviron" (without an extension) in the
project's root directory.
\item Run bellow code:
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{path <- file.path(reticulate::virtualenv_root(),
reticulate::virtualenv_list(), "Scripts", "python.exe")
paste("RETICULATE_PYTHON =", path)

}\if{html}{\out{</div>}}
\itemize{
\item Copy/paste the line from the console (the string between the quotes) into
the .Renviron file. This is an example \verb{RETICULATE_PYTHON = ~/.virtualenvs/r-reticulate/Scripts/python.exe}
\item Do not forget to save the changes
}

By following these steps, users can easily set up their environment to access
raw data efficiently, but it is not the only way of doing it.
}
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
