% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_reconstructed_sky.R
\name{fix_reconstructed_sky}
\alias{fix_reconstructed_sky}
\title{Fix reconstructed sky}
\usage{
fix_reconstructed_sky(sky, z, r, bin)
}
\arguments{
\item{sky}{\linkS4class{SpatRaster}. Sky DNs predicted with functions such as
\code{\link[=fit_coneshaped_model]{fit_coneshaped_model()}} and \code{\link[=fit_trend_surface]{fit_trend_surface()}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{r}{\linkS4class{SpatRaster}. The source of the sky DNs used to build
\code{sky} (the data source).}

\item{bin}{\linkS4class{SpatRaster}. The binarization of \code{r} used to
select the sky DNs for building the \code{sky} argument.}
}
\value{
An object of class \linkS4class{SpatRaster}. The argument \code{sky}
with dimensions unchanged but values edited.
}
\description{
Automatically edit a raster image of sky digital numbers (DNs) reconstructed
with functions such as \code{\link[=fit_coneshaped_model]{fit_coneshaped_model()}} and
\code{\link[=fit_trend_surface]{fit_trend_surface()}}.
}
\details{
The predicted sky DNs are usually erroneous near the horizon because either
they are a misleading extrapolation or are based on corrupted data (non-pure
sky DNs).

The proposed automatic edition consists of:
\itemize{
\item flattening the values below
the minimum value from the data source defined by \code{r} and
\code{bin}and
\item forcing the values toward the horizon to become gradually
the median value from the data source.
}

The latter is achieved by calculating
the weighted average of the median value and the predicted sky DNs, using the
ratio of \code{z} to \code{90} to determine the weights.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
caim <- normalize(caim, 0, 20847, TRUE)
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
bin <- find_sky_pixels(r, z, a)
sky <- fit_trend_surface(r, z, a, bin)$image
sky <- fix_reconstructed_sky(sky, z, r, bin)
plot(sky)
}
}
\seealso{
Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{interpolate_sky_points}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
