% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_coneshaped_model.R
\name{fit_coneshaped_model}
\alias{fit_coneshaped_model}
\title{Fit cone-shaped model}
\usage{
fit_coneshaped_model(
  r,
  z,
  a,
  bin,
  prob = 0.95,
  filling_source = NULL,
  use_azimuth_angle = TRUE,
  parallel = TRUE,
  free_cores = 0
)
}
\arguments{
\item{r}{\linkS4class{RasterLayer}. A normalized greyscale image. Typically,
the blue channel extracted from an hemispherical photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{zenith_image}}.}

\item{a}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{azimuth_image}}.}

\item{bin}{\linkS4class{RasterLayer}. A working binarized image. This should
be a preliminary binarization of \code{r}. If the function returns
\code{NA}, then the quality of this input should be revised.}

\item{prob}{Logical vector of length one. Probability for
\code{\link[stats]{quantile}} calculation. See reference
\insertCite{Diaz2018;textual}{rcaiman}.}

\item{filling_source}{\linkS4class{RasterLayer}. Default is \code{NULL}.
Above-canopy photograph. This image should contain pixels with sky DN
values and \code{NA} in all the other pixels. A photograph taken
immediately after or before taking \code{r} under the open sky with the
same equipment and configuration is a very good option. The ideal option is
one taken at the same time and place but above the canopy. The orientation
relative to the North must be the same than for \code{r}.}

\item{use_azimuth_angle}{Logical vector of length one. If \code{TRUE},
Equation 4 from \insertCite{Diaz2018;textual}{rcaiman} is used: \eqn{sDN =
a + b \cdot \theta + c  \cdot \theta^2 + d  \cdot sin(\phi) + e  \cdot
cos(\phi)}, where \eqn{sDN} is sky digital number, \eqn{a,b,c,d} and
\eqn{e} are coefficients, \eqn{\theta} is zenith angle, and \eqn{\phi} is
azimuth angle. If \code{FALSE}, a simplified version based on
\insertCite{Wagner2001;textual}{rcaiman} is used: \eqn{sDN = a + b \cdot
\theta + c  \cdot \theta^2}.}

\item{parallel}{Logical vector of length one. Allows parallel processing.}

\item{free_cores}{Numeric vector of length one. This number is subtracted to
the number of cores detected by \code{\link[parallel]{detectCores}}.}
}
\value{
A list with two objects, one of class \linkS4class{RasterLayer} and
  the other of class \code{lm} (see \code{\link[stats]{lm}}).
}
\description{
Generate the digital numbers of the whole sky through statistical modelling.
}
\details{
An explanation of this function can be found on
\insertCite{Diaz2018;textual}{rcaiman}, under the heading \emph{Estimation of
the sky DN as a previous step for our method}.

If you use this function in your research, please cite
\insertCite{Diaz2018}{rcaiman}.
}
\examples{
\dontrun{
path <- system.file("external/4_D_2_DSCN4502.JPG", package = "rcaiman")
r <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(r), lens("Nikon_FCE9"))
a <- azimuth_image(z)
blue <- gbc(r$Blue)
bin <- find_sky_pixels(blue, z, a)
sky <- fit_coneshaped_model(blue, z, a, bin, parallel = FALSE)
plot(sky$image)
persp(sky$image, theta = 90, phi = 0) #a flipped rounded cone!
}
}
\references{
\insertAllCited{}
}
\seealso{
Other MBLT functions: 
\code{\link{find_sky_pixels}()},
\code{\link{fit_trend_surface}()},
\code{\link{ootb_mblt}()},
\code{\link{thr_image}()}
}
\concept{MBLT functions}
