% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_plot.R
\name{theme_plot}
\alias{theme_plot}
\title{Override theme parameters for general plot attributes}
\usage{
theme_plot(
  fig,
  pars = NULL,
  background_fill_color = "white",
  background_fill_alpha = 1,
  border_fill_color = "white",
  border_fill_alpha = 1,
  outline_line_alpha = 1,
  outline_line_cap = "butt",
  outline_line_color = "black",
  outline_line_dash = NULL,
  outline_line_dash_offset = 0,
  outline_line_join = "miter",
  outline_line_width = 1,
  min_border = 50,
  min_border_bottom = 50,
  min_border_left = 50,
  min_border_right = 50,
  min_border_top = 50
)
}
\arguments{
\item{fig}{figure to modify}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}

\item{background_fill_color}{(color) background color of plot}

\item{background_fill_alpha}{(numeric) background color alpha of plot}

\item{border_fill_color}{(color) fill color of border area of plot}

\item{border_fill_alpha}{(numeric) fill color alpha of border area of plot}

\item{outline_line_alpha}{(numeric) The line alpha for the plot border outline.}

\item{outline_line_cap}{('butt', 'round', 'square') The line cap for the plot border outline.}

\item{outline_line_color}{(color) The line color for the plot border outline.}

\item{outline_line_dash}{The line dash for the plot border outline.}

\item{outline_line_dash_offset}{(integer) The line dash offset for the plot border outline.}

\item{outline_line_join}{('miter', 'round', 'bevel') The line join for the plot border outline.}

\item{outline_line_width}{(integer) The line width for the plot border outline.}

\item{min_border}{(integer) A convenience property to set all all the min_X_border properties to the same value. If an individual border property is explicitly set, it will override min_border.}

\item{min_border_bottom}{(integer) Minimum size in pixels of the padding region below the bottom of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_left}{(integer) Minimum size in pixels of the padding region to the left of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_right}{(integer) Minimum size in pixels of the padding region to the right of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_top}{(integer) Minimum size in pixels of the padding region above the top of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}
}
\description{
Override theme parameters for general plot attributes
}
\examples{
\donttest{
# manually specify a ggplot-like grid and background
figure() \%>\%
  ly_points(1:10) \%>\%
  theme_plot(background_fill_color = "#E6E6E6",
    outline_line_color = "white") \%>\%
  theme_grid(c("x", "y"), grid_line_color = "white",
    minor_grid_line_color = "white",
    minor_grid_line_alpha = 0.4) \%>\%
  theme_axis(c("x", "y"), axis_line_color = "white",
    major_label_text_color = "#7F7F7F",
    major_tick_line_color = "#7F7F7F",
    minor_tick_line_alpha = 0, num_minor_ticks = 2)

# or use the built in ggplot theme (under development)
figure(data = iris, legend = "top_left", tools = NULL) \%>\%
  ly_points(Sepal.Length, Petal.Length, color = Species) \%>\%
  set_theme(bk_ggplot_theme)
}
\dontrun{
# or to set the theme for all future plots
options(bokeh_theme = bk_ggplot_theme)

figure() \%>\%
  ly_points(1:10)

figure() \%>\%
  ly_boxplot(1:10)
}
}
