% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_shapes.R
\name{ly_crect}
\alias{ly_crect}
\title{Add a "crect" (centered rectangle) layer to a Bokeh figure}
\usage{
ly_crect(fig, x, y = NULL, data = figure_data(fig), width = 1,
  height = 1, angle = 0, dilate = FALSE, color = NULL, alpha = 1,
  hover = NULL, url = NULL, legend = NULL, lname = NULL,
  lgroup = NULL, visible = TRUE, ...)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{values or field name of center x coordinates}

\item{y}{values or field name of center y coordinates}

\item{data}{an optional data frame, providing the source for inputs xleft, ybottom, xright, ytop, and other glyph properties}

\item{width}{values or field name of widths}

\item{height}{values or field name of heights}

\item{angle}{values or field name of rotation angles}

\item{dilate}{logical - whether to dilate pixel distance computations when drawing}

\item{color}{color for the glyph - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' - for glyphs with both fill and line properties, see "Handling color" below}

\item{alpha}{the alpha transparency of the glyph between 0 (transparent) and 1 (opaque) - if glyph has both fill and color properties, see "Handling alpha" below}

\item{hover}{a data frame of variables to be displayed when hovering over the glyph or a vector of variable names that can be found and extracted from the \code{data} argument}

\item{url}{a string of URLs or a single string that references a variable name (via @var_name) that can be found and extracted from the \code{data} argument}

\item{legend}{either a logical specifying not to plot a legend for this layer (FALSE) or a string indicating the name of the legend entry for this layer (note that when mapping plot attributes to variables in \code{data}, a legend is automatically created and does not need to be specified - see "Mapped plot attributes and legends" below)}

\item{lname}{layer name}

\item{lgroup}{layer group}

\item{visible}{should the layer be visible?}

\item{\ldots}{additional parameters for fine control over fill and line properties (see "Additional parameters" below)}
}
\description{
Add a "crect" (centered rectangle) layer to a Bokeh figure
}
\section{Handling color}{
 The \code{color} parameter is a high-level plot attribute that provides default behavior for coloring glyphs.
\itemize{
  \item When using a glyph that only has line properties, this will be the color of the line.
  \item When using a glyph that has has line and fill properties, this will be the color of the line and the fill, with the alpha level of the fill reduced by 50\%.
  \item If full control over fill and line color is desired, the \code{fill_color} and \code{line_color} attributes can be specified explicitly and will override \code{color}.
}
When color is \code{NULL} and \code{fill_color} or \code{line_color} are not specified, the color will be chosen from the theme.
}

\section{Handling alpha}{
 The \code{alpha} is a high-level plot attribute that sets the transparency of the glyph being plotted.
\itemize{
  \item When using a glyph that only has line properties, this will be the alpha of the line.
  \item When using a glyph that has has line and fill properties, this will be the alpha of the line and the alpha of the fill will be set to 50\% of this value.
  \item Individual fill and line alpha can be specified with \code{fill_alpha} and \code{line_alpha} and will override \code{alpha}.
}
}

\section{Mapped plot attributes and legends}{
 When specifying an input data frame for a layer through the \code{data} argument, columns of \code{data} can be used to specify various plot attributes such as \code{color}, etc. For example, with \code{ly_points(..., data = iris, color = Species)}, the \code{Species} variable is used to determine how to color the points.  Here, \code{Species} is "mapped" to the \code{color} attribute.  Both continuous and categorical variables can be mapped.  In the case of continuous variables, the range is cut into slices and attributes are applied to each interval.  The mapping from the values of the variable to the actual plot attributes is determined based on the theme.
}

\section{Additional parameters}{

\tabular{ll}{
  \code{fill_color} \tab color to use to fill the glyph with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' \cr
  \code{fill_alpha} \tab transparency value between 0 (transparent) and 1 (opaque) \cr
  \code{line_color} \tab color to use to stroke lines with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' \cr
  \code{line_width} \tab stroke width in units of pixels \cr
  \code{line_alpha} \tab transparency value between 0 (transparent) and 1 (opaque) \cr
  \code{line_join} \tab how path segments should be joined together 'miter' 'round' 'bevel' \cr
  \code{line_cap} \tab how path segments should be terminated 'butt' 'round' 'square' \cr
  \code{line_dash} \tab array of integer pixel distances that describe the on-off pattern of dashing to use \cr
  \code{line_dash_offset} \tab the distance in pixels into the line_dash that the pattern should start from
 }
}
\examples{
\donttest{
# prepare data
elements <- subset(elements, !is.na(group))
elements$group <- as.character(elements$group)
elements$period <- as.character(elements$period)

# add colors for groups
metals <- c("alkali metal", "alkaline earth metal", "halogen",
  "metal", "metalloid", "noble gas", "nonmetal", "transition metal")
colors <- c("#a6cee3", "#1f78b4", "#fdbf6f", "#b2df8a", "#33a02c",
  "#bbbb88", "#baa2a6", "#e08e79")
elements$color <- colors[match(elements$metal, metals)]
elements$type <- elements$metal

# make coordinates for labels
elements$symx <- paste(elements$group, ":0.1", sep = "")
elements$numbery <- paste(elements$period, ":0.8", sep = "")
elements$massy <- paste(elements$period, ":0.15", sep = "")
elements$namey <- paste(elements$period, ":0.3", sep = "")

# create figure
p <- figure(title = "Periodic Table", tools = c("resize", "hover"),
  ylim = as.character(c(7:1)), xlim = as.character(1:18),
  xgrid = FALSE, ygrid = FALSE, xlab = "", ylab = "",
  height = 600, width = 1200) \%>\%

# plot rectangles
ly_crect(group, period, data = elements, 0.9, 0.9,
  fill_color = color, line_color = color, fill_alpha = 0.6,
  hover = list(name, atomic.number, type, atomic.mass,
    electronic.configuration)) \%>\%

# add symbol text
ly_text(symx, period, text = symbol, data = elements,
  font_style = "bold", font_size = "15pt",
  align = "left", baseline = "middle") \%>\%

# add atomic number text
ly_text(symx, numbery, text = atomic.number, data = elements,
  font_size = "9pt", align = "left", baseline = "middle") \%>\%

# add name text
ly_text(symx, namey, text = name, data = elements,
  font_size = "6pt", align = "left", baseline = "middle") \%>\%

# add atomic mass text
ly_text(symx, massy, text = atomic.mass, data = elements,
  font_size = "6pt", align = "left", baseline = "middle")

p
}
}
\seealso{
Other layer functions: \code{\link{ly_abline}},
  \code{\link{ly_annular_wedge}}, \code{\link{ly_annulus}},
  \code{\link{ly_arc}}, \code{\link{ly_bar}},
  \code{\link{ly_bezier}}, \code{\link{ly_boxplot}},
  \code{\link{ly_contour}}, \code{\link{ly_curve}},
  \code{\link{ly_density}}, \code{\link{ly_hist}},
  \code{\link{ly_image_url}}, \code{\link{ly_image}},
  \code{\link{ly_lines}}, \code{\link{ly_map}},
  \code{\link{ly_multi_line}}, \code{\link{ly_oval}},
  \code{\link{ly_patch}}, \code{\link{ly_points}},
  \code{\link{ly_polygons}}, \code{\link{ly_quadratic}},
  \code{\link{ly_quantile}}, \code{\link{ly_ray}},
  \code{\link{ly_rect}}, \code{\link{ly_segments}},
  \code{\link{ly_text}}, \code{\link{ly_wedge}}
}

