% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{split_imputations}
\alias{split_imputations}
\title{Split a flat list of \code{\link[=imputation_single]{imputation_single()}} into multiple \code{\link[=imputation_df]{imputation_df()}}'s by ID}
\usage{
split_imputations(list_of_singles, split_ids)
}
\arguments{
\item{list_of_singles}{A list of \code{\link[=imputation_single]{imputation_single()}}'s}

\item{split_ids}{A list with 1 element per required split. Each element
must contain a vector of "ID"'s which correspond to the \code{\link[=imputation_single]{imputation_single()}} ID's
that are required within that sample. The total number of ID's must by equal to the
length of \code{list_of_singles}}
}
\description{
Split a flat list of \code{\link[=imputation_single]{imputation_single()}} into multiple \code{\link[=imputation_df]{imputation_df()}}'s by ID
}
\details{
This function converts a list of imputations from being structured per patient
to being structured per sample i.e. it converts

\if{html}{\out{<div class="sourceCode">}}\preformatted{obj <- list(
    imputation_single("Ben", numeric(0)),
    imputation_single("Ben", numeric(0)),
    imputation_single("Ben", numeric(0)),
    imputation_single("Harry", c(1, 2)),
    imputation_single("Phil", c(3, 4)),
    imputation_single("Phil", c(5, 6)),
    imputation_single("Tom", c(7, 8, 9))
)

index <- list(
    c("Ben", "Harry", "Phil", "Tom"),
    c("Ben", "Ben", "Phil")
)
}\if{html}{\out{</div>}}

Into:

\if{html}{\out{<div class="sourceCode">}}\preformatted{output <- list(
    imputation_df(
        imputation_single(id = "Ben", values = numeric(0)),
        imputation_single(id = "Harry", values = c(1, 2)),
        imputation_single(id = "Phil", values = c(3, 4)),
        imputation_single(id = "Tom", values = c(7, 8, 9))
    ),
    imputation_df(
        imputation_single(id = "Ben", values = numeric(0)),
        imputation_single(id = "Ben", values = numeric(0)),
        imputation_single(id = "Phil", values = c(5, 6))
    )
)
}\if{html}{\out{</div>}}
}
