% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.r
\name{documentation_heatmap}
\alias{documentation_heatmap}
\title{documentation_heatmap}
\arguments{
\item{grid}{Color palette name, or a list with entries for \code{label},
\code{colors}, \code{range}, \code{bins}, \code{na.color}, and/or
\code{guide}. See the Track Definitions section for details.
Default: \code{list(label = "Grid Value", colors = "imola")}}

\item{label}{Label the matrix rows and columns. You can supply a list
or logical vector of length two to control row labels and column
labels separately, for example
\code{label = c(rows = TRUE, cols = FALSE)}, or simply
\code{label = c(TRUE, FALSE)}. Other valid options are \code{"rows"},
\code{"cols"}, \code{"both"}, \code{"bottom"}, \code{"right"},
and \code{"none"}.
Default: \code{TRUE}}

\item{label_size}{The font size to use for the row and column labels. You
can supply a numeric vector of length two to control row label sizes
and column label sizes separately, for example
\code{c(rows = 20, cols = 8)}, or simply \code{c(20, 8)}.
Default: \code{NULL}, which computes:
\code{pmax(8, pmin(20, 100 / dim(mtx)))}}

\item{rescale}{Rescale rows or columns to all have a common min/max.
Options: \code{"none"}, \code{"rows"}, or \code{"cols"}.
Default: \code{"none"}}

\item{trees}{Draw a dendrogram for rows (left) and columns (top). You can
supply a list or logical vector of length two to control the row tree
and column tree separately, for example
\code{trees = c(rows = TRUE, cols = FALSE)},
or simply \code{trees = c(TRUE, FALSE)}.
Other valid options are \code{"rows"}, \code{"cols"}, \code{"both"},
\code{"left"}, \code{"top"}, and \code{"none"}.
Default: \code{TRUE}}

\item{clust}{Clustering algorithm for reordering the rows and columns by
similarity. You can supply a list or character vector of length two to
control the row and column clustering separately, for example
\code{clust = c(rows = "complete", cols = NA)}, or simply
\code{clust = c("complete", NA)}. Options are:
\describe{
\item{\code{FALSE} or \code{NA} - }{ Disable reordering. }
\item{An \code{hclust} class object}{ E.g. from \code{\link[stats:hclust]{stats::hclust()}}. }
\item{A method name - }{ \code{"ward.D"},
\code{"ward.D2"}, \code{"single"}, \code{"complete"},
\code{"average"}, \code{"mcquitty"}, \code{"median"}, or
\code{"centroid"}. }
}
Default: \code{"complete"}}

\item{dist}{Distance algorithm to use when reordering the rows and columns
by similarity. You can supply a list or character vector of length
two to control the row and column clustering separately, for example
\code{dist = c(rows = "euclidean", cols = "maximum")}, or simply
\code{dist = c("euclidean", "maximum")}. Options are:
\describe{
\item{A \code{dist} class object}{ E.g. from \code{\link[stats:dist]{stats::dist()}} or \code{\link[=bdiv_distmat]{bdiv_distmat()}}. }
\item{A method name - }{ \code{"euclidean"},
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"},
\code{"binary"}, or \code{"minkowski"}. }
}
Default: \code{"euclidean"}}

\item{tree_height, track_height}{The height of the dendrogram or annotation
tracks as a percentage of the overall grid size. Use a numeric vector
of length two to assign \code{c(top, left)} independently.
Default: \code{10} (10\% of the grid's height)}

\item{asp}{Aspect ratio (height/width) for entire grid.
Default: \code{1} (square)}

\item{legend}{Where to place the legend. Options are: \code{"right"} or
\code{"bottom"}. Default: \code{"right"}}

\item{title}{Plot title. Set to \code{TRUE} for a default title, \code{NULL} for
no title, or any character string. Default: \code{TRUE}}

\item{...}{Additional arguments to pass on to ggplot2::theme().}
}
\value{
A \code{ggplot2} plot. The computed data points and ggplot
command are available as \verb{$data} and \verb{$code},
respectively.
}
\description{
documentation_heatmap
}
\keyword{internal}
