% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_event_hierarchy}
\alias{rba_reactome_event_hierarchy}
\title{Get Full Event Hierarchy of a Species}
\usage{
rba_reactome_event_hierarchy(species, ...)
}
\arguments{
\item{species}{Numeric or Character: NCBI Taxonomy identifier (Human Taxonomy
ID is 9606.) or species name (e.g. "Homo sapiens"). See
\code{\link{rba_reactome_species}} or
\href{https://reactome.org/content/schema/objects/Species/}{Reactome
Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List which is a representation of the species's events hierarchy
  described in the "Details section".
}
\description{
This function will retrieve the full Events hierarchy of your supplied
  species. Directly under each species, each child element is a "top Level
  Pathway". You can traverse the events tree down by following the "children"
  element.
}
\details{
By Reactome's definition, Events are the building blocks of biological
  processes and could be of two main classes: "Pathway" or
  "Reaction-like events". The events are organized in a hierarchical
  structure; and each event could be child or parent to another event; The
  hierarchy will always begin with a "Top level pathway" event. Also note
  that a given event could be part of more that one hierarchies.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/eventsHierarchy/{species}"
}

\examples{
\dontrun{
#very large response!
rba_reactome_event_hierarchy("Homo sapiens")
}
\dontrun{
#very large response!
rba_reactome_event_hierarchy(9606)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Queries Related to Events": 
\code{\link{rba_reactome_event_ancestors}()}
}
\concept{"Reactome Content Service - Queries Related to Events"}
