% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_est_Ar}
\alias{get_est_Ar}
\title{get the estimation of A and r}
\usage{
get_est_Ar(Y = 1, X, xi_interval, r_stepsize = 150)
}
\arguments{
\item{Y}{A numerical vector representing the sample data of variable Y.}

\item{X}{A numerical vector representing the sample data of variable X.}

\item{xi_interval}{A list with elements \code{xi_lb} and \code{xi_ub} representing the lower
and upper bounds of the frequency interval.}

\item{r_stepsize}{An integer value representing the number of steps in the r range.
This controls the granularity of the estimation. Higher values lead to finer
granularity but increase computation time.}
}
\value{
A named vector with elements \code{est_A} and \code{est_r} representing the estimated
values of A and r, respectively.
}
\description{
This function estimates the parameters A and r by optimizing an objective function
over a specified range of frequency values and r values.
}
\details{
The function internally defines a range for the natural logarithm of frequency values (\code{ln_xi_range})
and a range for the parameter \code{r} (\code{r_range}). It then defines an optimization function \code{optim_ln_A}
to minimize the integral of a given function over the \code{ln_xi_range}. The actual estimation is done by
finding the \code{r} and \code{A} value that minimizes the the area of the line \eqn{\ln A - r \ln \xi} under the constraint that the line should not go below the Fourier transform curve.
}
