% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-yc.R
\name{yc_superset}
\alias{yc_superset}
\alias{yc_usd_superset}
\alias{yc_ipca_superset}
\title{Creates superset with yield curves and futures}
\usage{
yc_superset(yc, fut)

yc_usd_superset(yc, fut)

yc_ipca_superset(yc, fut)
}
\arguments{
\item{yc}{yield curve dataset}

\item{fut}{futures dataset}
}
\value{
A dataframe with yield curve flagged with futures maturities.
}
\description{
Creates superset with yield curves and future contracts indicating the
terms that match with futures contracts maturities.
}
\examples{
\dontrun{
fut <- futures_get(Sys.Date() - 1)

yc <- yc_get(Sys.Date() - 1)
yc_superset(yc, fut)

yc_usd <- yc_usd_get(Sys.Date() - 1)
yc_usd_superset(yc_usd, fut)

yc_ipca <- yc_ipca_get(Sys.Date() - 1)
yc_ipca_superset(yc_ipca, fut)
}
}
