% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/material_functions.R
\name{change_material}
\alias{change_material}
\title{Change Material}
\usage{
change_material(
  mesh,
  id = NULL,
  sub_id = 1,
  diffuse = NULL,
  ambient = NULL,
  specular = NULL,
  transmittance = NULL,
  emission = NULL,
  shininess = NULL,
  ior = NULL,
  dissolve = NULL,
  illum = NULL,
  texture_location = NULL,
  normal_texture_location = NULL,
  bump_texture_location = NULL,
  specular_texture_location = NULL,
  ambient_texture_location = NULL,
  emissive_texture_location = NULL,
  diffuse_intensity = NULL,
  bump_intensity = NULL,
  specular_intensity = NULL,
  emission_intensity = NULL,
  ambient_intensity = NULL,
  culling = NULL,
  type = NULL,
  translucent = NULL,
  toon_levels = NULL,
  toon_outline_width = NULL,
  toon_outline_color = NULL,
  reflection_intensity = NULL,
  reflection_sharpness = NULL,
  two_sided = NULL
)
}
\arguments{
\item{mesh}{Mesh to change.}

\item{id}{Default \code{NULL}. Either a number specifying the material to change, or a character vector
matching the material name.}

\item{sub_id}{Default \code{1}. A number specifying which material to change (within an id).}

\item{diffuse}{Default \code{NULL}. The diffuse color.}

\item{ambient}{Default \code{NULL}. The ambient color.}

\item{specular}{Default \code{NULL}. The specular color.}

\item{transmittance}{Default \code{NULL}. The transmittance}

\item{emission}{Default \code{NULL}. The emissive color.}

\item{shininess}{Default \code{NULL}. The shininess exponent.}

\item{ior}{Default \code{NULL}. The index of refraction. If this is not equal to \code{1.0}, the material will be refractive.}

\item{dissolve}{Default \code{NULL}. The transparency.}

\item{illum}{Default \code{NULL}. The illumination.}

\item{texture_location}{Default \code{NULL}. The diffuse texture location.}

\item{normal_texture_location}{Default \code{NULL}. The normal texture location.}

\item{bump_texture_location}{Default \code{NULL}. The bump texture location.}

\item{specular_texture_location}{Default \code{NULL}. The specular texture location.}

\item{ambient_texture_location}{Default \code{NULL}. The ambient texture location.}

\item{emissive_texture_location}{Default \code{NULL}. The emissive texture location.}

\item{diffuse_intensity}{Default \code{NULL}. The diffuse intensity.}

\item{bump_intensity}{Default \code{NULL}. The bump intensity.}

\item{specular_intensity}{Default \code{NULL}. The specular intensity.}

\item{emission_intensity}{Default \code{NULL}. The emission intensity.}

\item{ambient_intensity}{Default \code{NULL}. The ambient intensity.}

\item{culling}{Default \code{NULL}. The culling type. Options are \code{back}, \code{front}, and \code{none}.}

\item{type}{Default \code{NULL}. The shader type. Options include \code{diffuse},\code{phong},\code{vertex}, and \code{color}.}

\item{translucent}{Default \code{NULL}. Whether light should transmit through a semi-transparent material.}

\item{toon_levels}{Default \code{NULL}. Number of color breaks in the toon shader.}

\item{toon_outline_width}{Default \code{NULL}. Expansion term for model to specify toon outline width. Note: setting this property via this function currently does not generate outlines. Specify it during object creation.}

\item{toon_outline_color}{Default \code{NULL}. Toon outline color.Note: setting this property via this function currently does not color outlines. Specify it during object creation.}

\item{reflection_intensity}{Default \code{NULL}. Intensity of the reflection of the environment map, if present. This will be ignored if the material is refractive.}

\item{reflection_sharpness}{Default \code{NULL}. Sharpness of the reflection, where lower values have blurrier reflections. Must be greater than zero and less than one.}

\item{two_sided}{Default \code{NULL}. Whether diffuse materials should be two sided (normal is taken as the absolute value of the dot product of the light direction and the normal).}
}
\value{
Shape with new material settings
}
\description{
Change individual material properties, leaving others alone.
}
\examples{
if(run_documentation()) {
p_sphere = sphere_mesh(position=c(555/2,555/2,555/2), 
                      radius=40,material=material_list(diffuse="purple"))
generate_cornell_mesh() |>
 add_shape(p_sphere) |>
 add_shape(change_material(translate_mesh(p_sphere,c(200,0,0)),diffuse="red")) |>
 add_shape(change_material(translate_mesh(p_sphere,c(100,0,0)),dissolve=0.5)) |>
 add_shape(change_material(translate_mesh(p_sphere,c(-100,0,0)),type="phong")) |>
 add_shape(change_material(translate_mesh(p_sphere,c(-200,0,0)),type="phong",shininess=30)) |>
 rasterize_scene(light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
