% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{text3d}
\alias{text3d}
\title{Text Object}
\usage{
text3d(
  label,
  x = 0,
  y = 0,
  z = 0,
  text_height = 1,
  orientation = "xy",
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  velocity = c(0, 0, 0),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{label}{Text string.}

\item{x}{Default `0`. x-coordinate of the center of the label.}

\item{y}{Default `0`. y-coordinate of the center of the label.}

\item{z}{Default `0`. z-coordinate of the center of the label.}

\item{text_height}{Default `1`. Height of the text.}

\item{orientation}{Default `xy`. Orientation of the plane. Other options are `yz` and `xz`.}

\item{material}{Default  \code{\link{diffuse}}. The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{velocity}{Default `c(0, 0, 0)`. Velocity of the sphere, used for motion blur.}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the text in the scene.
}
\description{
Text Object
}
\examples{
#Generate a label in the cornell box.
\donttest{
generate_cornell() \%>\% 
  add_object(text3d(label="Cornell Box", x=555/2,y=555/2,z=555/2,text_height=60,
                    material=diffuse(color="grey10"), angle=c(0,180,0))) \%>\% 
  render_scene(samples=500, clamp_value=10)
  
#Change the orientation
generate_cornell() \%>\% 
  add_object(text3d(label="YZ Plane", x=550,y=555/2,z=555/2,text_height=100,
                    orientation = "yz",
                    material=diffuse(color="grey10"), angle=c(0,180,0))) \%>\% 
 add_object(text3d(label="XY Plane", z=550,y=555/2,x=555/2,text_height=100,
                    orientation = "xy",
                    material=diffuse(color="grey10"), angle=c(0,180,0))) \%>\% 
 add_object(text3d(label="XZ Plane", z=555/2,y=5,x=555/2,text_height=100,
                    orientation = "xz",
                    material=diffuse(color="grey10"))) \%>\% 
  render_scene(samples=500, clamp_value=10)
  
#Add an label in front of a sphere
generate_cornell() \%>\% 
  add_object(text3d(label="Cornell Box", x=555/2,y=555/2,z=555/2,text_height=60,
                    material=diffuse(color="grey10"), angle=c(0,180,0))) \%>\% 
  add_object(text3d(label="Sphere", x=555/2,y=100,z=100,text_height=30,
                    material=diffuse(color="white"), angle=c(0,180,0))) \%>\% 
  add_object(sphere(y=100,radius=100,z=555/2,x=555/2,
                    material=glossy(color="purple"))) \%>\% 
  add_object(sphere(y=555,radius=100,z=-1000,x=555/2,
                    material=light(intensity=100,
                                   spotlight_focus=c(555/2,100,100)))) \%>\%                   
  render_scene(samples=500, clamp_value=10)
  
  
#A room full of bees
bee_list = list()
for(i in 1:100) {
bee_list[[i]] = text3d("B", x=20+runif(1)*525, y=20+runif(1)*525, z=20+runif(1)*525, 
                       text_height = 50, angle=c(0,180,0))
}
bees = do.call(rbind,bee_list)
generate_cornell() \%>\% 
  add_object(bees) \%>\%                   
  render_scene(samples=500, clamp_value=10)
}
}
