% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_distance.R
\name{render_boolean_distance}
\alias{render_boolean_distance}
\title{Render Boolean Distance}
\usage{
render_boolean_distance(boolean, rescale = FALSE)
}
\arguments{
\item{boolean}{Logical matrix (or matrix of 1s and 0s), where distance will be measured to the \code{TRUE} values.}

\item{rescale}{Default \code{FALSE}. Rescales the calculated distance to a range of 0-1.
Useful for visualizing the distance matrix.}
}
\value{
Matrix of distance values.
}
\description{
Takes an matrix (or  and returns the nearest distance to each TRUE.
}
\examples{
#Measure distance to
image(render_boolean_distance(volcano > 150))
image(render_boolean_distance(volcano < 150))

#If we want to rescale this to zero to one (to visualize like an image), set rescale=TRUE
plot_image(render_boolean_distance(volcano > 150,rescale=TRUE))
}
