% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray_write_image.R
\name{ray_write_image}
\alias{ray_write_image}
\title{Write Image}
\usage{
ray_write_image(image, filename, clamp = TRUE, ...)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{filename}{File to write to, with filetype determined by extension. Filetype can be
\code{PNG}, \code{JPEG}, or \code{TIFF}.}

\item{clamp}{Default \code{TRUE}. Whether to clamp the image to 0-1. If the file extension is \code{PNG} of \code{JPEG},
this is forced to \code{TRUE}.}

\item{...}{Arguments to pass to either \code{jpeg::writeJPEG}, \code{png::writePNG}, or \code{tiff::writeTIFF}.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and writes it to file.
}
\examples{
if(run_documentation()){
#Write as a png
tmparr = tempfile(fileext=".png")
ray_read_image(dragon) |>
 ray_write_image(tmparr)
ray_read_image(tmparr) |>
 plot_image()
}
if(run_documentation()){
#Write as a JPEG (passing quality arguments via ...)
tmparr = tempfile(fileext=".jpg")
ray_read_image(dragon) |>
 ray_write_image(tmparr, quality = 0.2)
ray_read_image(tmparr) |>
 plot_image()
}
if(run_documentation()){
#Write as a tiff
tmparr = tempfile(fileext=".tiff")
ray_read_image(dragon) |>
 ray_write_image(tmparr)
ray_read_image(tmparr) |>
  plot_image()
}
}
