% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_subdivision}
\alias{vcg_subdivision}
\title{Sub-divide (up-sample) a triangular mesh}
\usage{
vcg_subdivision(mesh, method = c("edge", "barycenter"))
}
\arguments{
\item{mesh}{triangular mesh stored as object of class 'mesh3d'.}

\item{method}{either \code{'edge'} (default) to add new mid-point vertices to
edge, or \code{'barycenter'} to add new vertices at face \code{'Bary'}
centers.}
}
\value{
An object of class "mesh3d"
}
\description{
Up-sample a triangular mesh by adding a vertex at each edge or face center.
}
\examples{

mesh <- plane_geometry()

# default
mesh_edge <- vcg_subdivision(mesh, "edge")

# barycenter
mesh_face <- vcg_subdivision(mesh, "barycenter")

if(is_not_cran()) {

  rgl_view({
    rgl_call("wire3d", mesh, col = 1)
    rgl_call("wire3d", mesh_edge, col = 2)
    rgl_call("wire3d", mesh_face, col = 3)
  })


}



}
