% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{detrend}
\alias{detrend}
\title{Remove the trend for one or more signals}
\usage{
detrend(x, trend = c("constant", "linear"), break_points = NULL)
}
\arguments{
\item{x}{numerical or complex, a vector or a matrix}

\item{trend}{the trend of the signal; choices are \code{'constant'} and
\code{'linear'}}

\item{break_points}{integer vector, or \code{NULL}; only used when
\code{trend} is \code{'linear'} to remove piecewise linear trend; will
throw warnings if \code{trend} is \code{'constant'}}
}
\value{
The signals with trend removed in matrix form; the number of columns
is the number of signals, and number of rows is length of the signals
}
\description{
'Detrending' is often used before the signal power calculation.
}
\examples{

x <- rnorm(100, mean = 1) + c(
  seq(0, 5, length.out = 50),
  seq(5, 3, length.out = 50))
plot(x)

plot(detrend(x, 'constant'))
plot(detrend(x, 'linear'))
plot(detrend(x, 'linear', 50))

}
