% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-watch-dog.R
\name{auto_process_blackrock}
\alias{auto_process_blackrock}
\title{Monitors 'BlackRock' output folder and automatically import data into 'RAVE'}
\usage{
auto_process_blackrock(
  watch_path,
  project_name = "automated",
  task_name = "RAVEWatchDog",
  scan_interval = 10,
  time_threshold = Sys.time(),
  max_jobs = 1L,
  as_job = NA,
  dry_run = FALSE
)
}
\arguments{
\item{watch_path}{the folder to watch}

\item{project_name}{the project name to generate}

\item{task_name}{the watcher's name}

\item{scan_interval}{scan the directory every \code{scan_interval} seconds,
cannot be lower than 1}

\item{time_threshold}{time-threshold of files: all files with modified
time prior to this threshold will be ignored; default is current time}

\item{max_jobs}{maximum concurrent imports, default is 1}

\item{as_job}{whether to run in 'RStudio' background job or to block the
session when monitoring; default is auto-detected}

\item{dry_run}{whether to dry-run the code (instead of executing the
scripts, return the watcher's instance and open the settings file);
default is false}
}
\value{
When \code{dry_run} is true, then the watcher's instance will be
returned; otherwise nothing will be returned.
}
\description{
Automatically import 'BlackRock' files from designated folder
and perform 'Notch' filters, 'Wavelet' transform; also generate epoch,
reference files.
}
