% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-BlackrockFile.R
\name{BlackrockFile}
\alias{BlackrockFile}
\title{Class definition to load data from 'BlackRock' 'Micro-systems' files}
\description{
Currently only supports minimum file specification version
\code{2.3}. Please contact the package maintainer or 'RAVE' team
if older specifications are needed
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{block}}{character, session block ID}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{base_path}}{absolute base path to the file}

\item{\code{version}}{'NEV' specification version}

\item{\code{electrode_table}}{electrode table}

\item{\code{sample_rate_nev_timestamp}}{sample rate of 'NEV' data packet
time-stamps}

\item{\code{has_nsx}}{named vector of 'NSx' availability}

\item{\code{recording_duration}}{recording duration of each 'NSx'}

\item{\code{sample_rates}}{sampling frequencies of each 'NSx' file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BlackrockFile-print}{\code{BlackrockFile$print()}}
\item \href{#method-BlackrockFile-new}{\code{BlackrockFile$new()}}
\item \href{#method-BlackrockFile-nev_path}{\code{BlackrockFile$nev_path()}}
\item \href{#method-BlackrockFile-nsx_paths}{\code{BlackrockFile$nsx_paths()}}
\item \href{#method-BlackrockFile-refresh_data}{\code{BlackrockFile$refresh_data()}}
\item \href{#method-BlackrockFile-get_epoch}{\code{BlackrockFile$get_epoch()}}
\item \href{#method-BlackrockFile-get_waveform}{\code{BlackrockFile$get_waveform()}}
\item \href{#method-BlackrockFile-get_electrode}{\code{BlackrockFile$get_electrode()}}
\item \href{#method-BlackrockFile-clone}{\code{BlackrockFile$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-print"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-print}{}}}
\subsection{Method \code{print()}}{
print user-friendly messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-new"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$new(path, block)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{the path to 'BlackRock' file, can be with or without file
extensions}

\item{\code{block}}{session block ID; default is the file name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-nev_path"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-nev_path}{}}}
\subsection{Method \code{nev_path()}}{
get 'NEV' file path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$nev_path()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
absolute file path
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-nsx_paths"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-nsx_paths}{}}}
\subsection{Method \code{nsx_paths()}}{
get 'NSx' file paths
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$nsx_paths(which = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which}}{which signal file to get, or \code{NULL} to return all
available paths, default is \code{NULL}; must be integers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
absolute file paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-refresh_data"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-refresh_data}{}}}
\subsection{Method \code{refresh_data()}}{
refresh and load 'NSx' data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$refresh_data(force = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{whether to force reload data even if the data has been
loaded and cached before}

\item{\code{verbose}}{whether to print out messages when loading}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-get_epoch"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-get_epoch}{}}}
\subsection{Method \code{get_epoch()}}{
get epoch table from the 'NEV' comment data packet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$get_epoch()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-get_waveform"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-get_waveform}{}}}
\subsection{Method \code{get_waveform()}}{
get 'waveform' of the spike data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$get_waveform()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of spike 'waveform' (without normalization)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-get_electrode"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-get_electrode}{}}}
\subsection{Method \code{get_electrode()}}{
get electrode data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$get_electrode(electrode, nstype = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{electrode}}{integer, must be a length of one}

\item{\code{nstype}}{which signal bank, for example, \code{'ns3'}, \code{'ns5'}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a normalized numeric vector (analog signals with \code{'uV'}
as the unit)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlackrockFile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BlackrockFile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlackrockFile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
