% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpaRaoS.R
\name{mpaRaoS}
\alias{mpaRaoS}
\title{Multidimensional sequential Parametric Rao's index of quadratic entropy (Q)}
\usage{
mpaRaoS(
  x,
  alpha,
  window,
  dist_m,
  na.tolerance,
  rescale,
  lambda,
  diag,
  debugging,
  isfloat,
  mfactor,
  np
)
}
\arguments{
\item{x}{input list.}

\item{alpha}{Numeric; alpha value for order of diversity in Hill's Index.}

\item{window}{Numeric; half of the side of the square moving window used for calculation.}

\item{dist_m}{Character; type of distance used in the analysis.}

\item{na.tolerance}{Numeric; a threshold between 0.0 and 1.0 indicating the allowable proportion of NA 
values within each moving window. If the proportion of NA values exceeds this, the window's value is set as 
NA; otherwise, the computation uses the non-NA values.}

\item{rescale}{Logical; if TRUE, scales and centres the values in each element of 'x'.}

\item{lambda}{Numeric; lambda value used for Minkowski distance calculation.}

\item{diag}{Logical; if TRUE, includes the diagonal of the distance matrix in computations.}

\item{debugging}{Logical; if TRUE, additional diagnostic messages are output, useful for debugging. Default 
is FALSE.}

\item{isfloat}{Logical; specifies if the input data are floats.}

\item{mfactor}{Numeric; multiplication factor applied if input data are float numbers.}

\item{np}{Number of processes for parallel computation.}
}
\value{
A list of matrices, each representing a layer of the input RasterStack, containing calculated 
Rao's index values. The dimensions correspond to those of the input, and the list length is equal to the 
length of 'alpha'.
}
\description{
This function calculates the multidimensional parametric Rao's index of quadratic entropy (Q) using a 
sequential method. It is particularly useful in contexts where parallel computation is not feasible or desired.
The function applies a moving window approach to the provided raster data stack.
}
\seealso{
\code{\link{paRao}} for the parallelized version of the Rao's index computation.
}
\author{
Duccio Rocchini \email{duccio.rocchini@unibo.it}, 
Matteo Marcantonio \email{marcantoniomatteo@gmail.com}
}
