% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Spin or Knit and Render a `Rasciidoc` File}
\usage{
render(
  file_name,
  knit = NA,
  write_to_disk = getOption("write_to_disk"),
  envir = parent.frame(),
  hooks = c("message", "error", "warning"),
  replacement = "source",
  asciidoc_args = "-b html",
  what = c("auto", "all", "no_slides", "slides"),
  git_checkout_asciidoc_tag = NA,
  clean = FALSE,
  ...
)
}
\arguments{
\item{file_name}{The file to render.}

\item{knit}{Knit the file first using \code{\link[knitr:knit]{knitr::knit}}?
If set to \code{\link{NA}}, knitting is based on the file's contents or name.
Set to \code{\link{TRUE}}
to force knitting or to \code{\link{FALSE}}, to disable knitting.}

\item{write_to_disk}{Write to disk? See \bold{Warning}.}

\item{envir}{The frame in which to render.}

\item{hooks}{Character vector naming the output hooks to be replaced by
the \code{replacement}'s hooks.}

\item{replacement}{The hook with which to replace the hooks given by
\code{hooks}.}

\item{asciidoc_args}{arguments passed to \command{asciidoc} via
\code{\link{system2}}.}

\item{what}{What is to be rendered? \code{"all"} renders everything,
\code{"no_slides"} renders parts that are not meant for slides,
\code{"slides"} renders parts that are meant for slides.
The defaults looks
for any in- or exclusion tagging and renders parts that are not meant for
slides if found any, else it renders everything.}

\item{git_checkout_asciidoc_tag}{If \command{asciidoc} is not installed, it
is loaded from \url{https://github.com/}.
Depending on your python version (python2 or python3), \command{asciidoc} for
python2 or python3 is loaded. You may specify a tag to use with the
repository.
Either pass
\enumerate{
  \item a tag number as a string ("9.1.0", for example),
  \item \code{\link{NULL}} to force the latest tagged version, or
  \item \code{\link{NA}}
}
Don't mind, just stick with the default. You would have to know which python
version will be used.}

\item{clean}{Remove temporary file(s)?}

\item{...}{Only there to register as vignette engine. Do not use!}
}
\value{
The return value of \code{\link{rasciidoc}}.
}
\description{
Spin or Knit (if required) and render an `Rasciidoc` file.
}
\section{Warning}{

Due to the CRAN policy of not writing "anywhere else on the
file system apart from the R session's temporary directory",
we work on a temporary copy of \code{file_name}.
Thus all internal sourcing and internal links will be
broken and any output is written to \code{tempdir()}.
Set the option "write_to_disk" to TRUE (using \cr
\code{options(write_to_disk = TRUE)}\cr
to bypass this. You may want to include the above line into your
\file{~/.Rprofile}.
}

\examples{
# CRAN complains about elapsed times
if (fritools::is_running_on_fvafrcu_machines()) {
    wd <- file.path(tempdir(), "rasciidoc")
    dir.create(wd)
    file  <- system.file("files", "minimal", "knit.Rasciidoc",
                         package = "rasciidoc")
    file.copy(file, wd)
    r <- rasciidoc::render(file.path(wd, basename(file)),
                           write_to_disk = getOption("write_to_disk"),
                           asciidoc_args = "-b slidy")
    if (isTRUE(getOption("write_to_disk"))) {
        dir(wd, full.names = TRUE)
    } else {
        dir(tempdir(), full.names = TRUE)
    }
    unlink(wd, recursive = TRUE)
}
}
\seealso{
\code{\link{rasciidoc}}
}
