% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{raqs_options}
\alias{raqs_options}
\title{Package options}
\description{
The following package options can be set via \link{options} and queried via
\link{getOption}.
}
\section{Options to handle the AQS API rate limits}{


The AQS API recommends not to make more than 10 requests per minute and
pause 5 seconds between requests.
\itemize{
\item \code{raqs.req_per_min} controls the maximum number of API requests per minute.
Default is 10.
\item \code{raqs.delay_between_req} controls a delay between API requests sent via a
function when your \code{bdate} and \code{edate} inputs span multiple years. A value
will be rounded to the nearest integer. Default is 5 seconds.
\item \code{raqs.delay_fun_exit} controls a delay before a function execution ends. A
value will be rounded to the nearest integer. Default is zero if R is being
used interactively. Otherwise, it is 5 seconds. This option only applies to
functions that send API requests.
}
}

\section{Option to handle the type of data object to return}{


By default, the parsed data will be returned as a \link{data.frame} object, but
can be adjusted for users' preferences.
\itemize{
\item \code{raqs.return_type} controls the type of data object to return. Default is
"data.frame" but it can also be set to "tibble" or "data.table".
}
}

\examples{

## Change for the duration of the session
op <- options(raqs.rep_per_min = 5)

## Change back to the original value
options(op)

}
