% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mb.R
\name{fit_mb}
\alias{fit_mb}
\title{Calculate the exact or approximate MLE of a Mallows-Binomial distribution using various methods}
\usage{
fit_mb(
  Pi,
  X,
  M,
  method = c("ASTAR", "ASTAR_LP", "Greedy", "GreedyLocal", "FV"),
  localsearch = 0
)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{X}{Matrix of ratings, one row per judge and one column per object.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{method}{String specifying method, with allowable options "ASTAR","ASTAR_LP","Greedy","GreedyLocal",and "FV".}

\item{localsearch}{Numeric for use with the Greedy and FV methods; ignored otherwise. See documentation of those estimation functions for details. Defaults to 0, indicating no local search.}
}
\value{
List with elements pi0 (estimated consensus ranking MLE),  p (estimated object quality parameter MLE), theta (estimated scale parameter MLE), and numnodes (number of nodes traversed during algorithm, a measure of computational complexity).
}
\description{
This function calculates the exact or approximate MLE of a Mallows-Binomial distribution using a user-specified method.
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
X <- matrix(c(0,1,2,3,1,2,2,5),byrow=TRUE,nrow=2)
fit_mb(Pi=Pi,X=X,M=5,method="ASTAR")
fit_mb(Pi=Pi,X=X,M=5,method="Greedy",localsearch=0)
fit_mb(Pi=Pi,X=X,M=5,method="GreedyLocal")
fit_mb(Pi=Pi,X=X,M=5,method="FV",localsearch=3)
 
}
