% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assemblageFetch-methods.R
\docType{methods}
\name{assemblageFetch}
\alias{assemblageFetch}
\alias{assemblageFetch,rangeMap,SpatialPoints,character-method}
\alias{assemblageFetch,rangeMap,SpatialPoints,missing-method}
\title{Retrieves the species set of an arbitrary canvas cell}
\usage{
assemblageFetch(object, xy, BIO)

\S4method{assemblageFetch}{rangeMap,SpatialPoints,missing}(object, xy)

\S4method{assemblageFetch}{rangeMap,SpatialPoints,character}(object, xy, BIO)
}
\arguments{
\item{object}{A \code{connection} object.}

\item{xy}{A \code{\link[sp]{SpatialPoints}} object.}

\item{BIO}{The name of the \code{BIO_table} containing species life-history data.}
}
\value{
A \code{data.frame} containing the bioid (e.g. species names),
                the canvas id and optionally any associated life history data contained
                in the \code{BIO_table} table.
}
\description{
\code{assemblageFetch} retrieves the species set of an arbitrary canvas cell
optionally with the associated life history data
}
\examples{

require(rangeMapper)
require(rgdal)

projName = "wrens.sqlite"
projLoc = paste(tempdir(), projName, sep = .Platform$file.sep)

dbcon = rangeMap.start(file = projName,dir = tempdir() , overwrite = TRUE)
f = system.file(package = "rangeMapper", "extdata", "wrens", "vector_combined")
r = readOGR(f, "wrens", verbose = FALSE)
global.bbox.save(con = dbcon, bbox = r)
gridSize.save(dbcon, gridSize = 3)
canvas.save(dbcon)
data(wrens)
bio.save(con = dbcon, loc = wrens ,  ID = "sci_name")
processRanges(spdf = r, con =  dbcon, ID = "sci_name")
rangeMap.save(dbcon)

sr = rangeMap.fetch(dbcon)
image(sr, axes = TRUE); grid()

p = list(x = -76.39, y = 9.26)
# or use locator:  p =  locator(1)

xy = SpatialPoints( do.call(cbind, p), proj4string = CRS("+proj=longlat +datum=NAD83 +no_defs ") )
af = assemblageFetch(rangeMap(projLoc) , xy)
points(p, col = 4, cex = 2)
print(af)

af = assemblageFetch(rangeMap(projLoc) , xy, "wrens")
print(af[, c(1, 4, 6:8)])


}

