% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installation.R
\name{dockerize}
\alias{dockerize}
\alias{dockerize_rang}
\alias{dockerise}
\alias{dockerise_rang}
\title{Dockerize The Resolved Result}
\usage{
dockerize(
  rang,
  output_dir,
  materials_dir = NULL,
  image = c("r-ver", "rstudio", "tidyverse", "verse", "geospatial"),
  rang_as_comment = TRUE,
  cache = FALSE,
  verbose = TRUE,
  lib = NA,
  cran_mirror = "https://cran.r-project.org/",
  check_cran_mirror = TRUE
)

dockerize_rang(...)

dockerise(...)

dockerise_rang(...)
}
\arguments{
\item{rang}{output from \code{\link[=resolve]{resolve()}}}

\item{output_dir}{character, where to put the Docker file and associated content}

\item{materials_dir}{character, path to the directory containing additional resources (e.g. analysis scripts) to be copied into \code{output_dir} and in turn into the Docker container}

\item{image}{character, which versioned Rocker image to use. Can only be "r-ver", "rstudio", "tidyverse", "verse", "geospatial"
This applies only to R version <= 3.1}

\item{rang_as_comment}{logical, whether to write resolved result and the steps to reproduce
the file to \code{path} as comment}

\item{cache}{logical, whether to cache the packages now. Please note that the system requirements are not cached. For query with non-CRAN packages, this option is strongly recommended. For R version < 3.1, this must be TRUE if there is any non-CRAN packages.}

\item{verbose}{logical, pass to \code{\link[=install.packages]{install.packages()}}, the negated value is also passed as \code{quiet} to both \code{\link[=install.packages]{install.packages()}}
and \code{\link[=download.file]{download.file()}}.}

\item{lib}{character, pass to \code{\link[=install.packages]{install.packages()}}. By default, it is NA (to install the packages to the default location)}

\item{cran_mirror}{character, which CRAN mirror to use}

\item{check_cran_mirror}{logical, whether to check the CRAN mirror}

\item{...}{arguments to be passed to \code{dockerize}}
}
\value{
\code{output_dir}, invisibly
}
\description{
This function exports the result from \code{\link[=resolve]{resolve()}} to a Docker file. For R version >= 3.1.0, the Dockerfile is based on the versioned Rocker image.
For R version < 3.1.0, the Dockerfile is based on Debian and it compiles R from source.
}
\details{
The idea behind this is to determine the installation order of R packages locally. Then, the installation script can be depolyed to another
fresh R session to install R packages. \code{\link[=dockerize]{dockerize()}} is a more reasonable way because a fresh R session with all system requirements
is provided. The current approach does not work in R < 2.1.0.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                    snapshot_date = "2020-01-16")
    dockerize(graph, ".")
}
}
}
\references{
\href{https://rocker-project.org}{The Rocker Project}
Ripley, B. (2005) \href{https://cran.r-project.org/doc/Rnews/Rnews_2005-1.pdf}{Packages and their Management in R 2.1.0.} R News, 5(1):8--11.
}
\seealso{
\code{\link[=resolve]{resolve()}}, \code{\link[=export_rang]{export_rang()}}
}
