/** 
 * @file  testrng.c
 * @brief C file for RNG tests
 *
 * @author Christophe Dutang
 *
 *
 * Copyright (C) 2009, Christophe Dutang. 
 * All rights reserved.
 *
 * The new BSD License is applied to this software.
 * Copyright (c) 2009 Christophe Dutang. 
 * All rights reserved.
 *
 *      Redistribution and use in source and binary forms, with or without
 *      modification, are permitted provided that the following conditions are
 *      met:
 *      
 *          - Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *          - Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *          - Neither the names of its contributors may be used to endorse or promote 
 *          products derived from this software without specific prior written
 *          permission.
 *     
 *      THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *      "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *      LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *      A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *      OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *      SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *      LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *      DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *      THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *      (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *      OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 */
/*****************************************************************************
 *  Test of random numbers generated by computers
 *
 *		C functions	
 *  
 *	Many ideas are taken from http://homepage.mac.com/s_lott/steve/python/rngdoc.html
 *
 */

#include "testrng.h"



/**************/
/* constants */



/*********************************/
/* tests */

//main function used .Call()
SEXP doPokerTest(SEXP hands, SEXP n, SEXP d)
{
/*    if(n == NULL) Rprintf("blii\n");
    else Rprintf("toooo\n"); 
    */
        if (!isNumeric(hands))
                error(_("invalid argument zogzog"));
        if(!isNumeric(n))
                error(_("invalid argument***********"));
        if(!isNumeric(d))
                error(_("invalid argument________"));

    //Rprintf("zogzog\n");    
        //temporary working variables
        int dim  = asInteger( d ); //dimension of vector
        int nbh = asInteger( n ); //number of observed hands
    //Rprintf("zogzog\n");

        
        int *rHands = INTEGER( hands ); // 'n'x'd' matrix of obs. hands 
    /*
    if(rHands == NULL) Rprintf("blii1\n");
    else Rprintf("toooo1\n"); 
    */
    SEXP dims = getAttrib(hands, R_DimSymbol); //extract dimensions
/*
    if(INTEGER(dims) == NULL  ) Rprintf("blii2\n");
    else Rprintf("toooo2\n"); 
*/
    
    if (nbh != INTEGER(dims)[0] || dim != INTEGER(dims)[1])
        error(_("invalid argument hands"));
    
	
        //result
        int *valuePresent = (int *) R_alloc(dim, sizeof(int));
        SEXP resultinR; //result in R
        PROTECT(resultinR = allocVector(INTSXP, dim)); //allocate a d vector
/*
        if(resultinR == NULL) Rprintf("zog\n");
    else Rprintf("toooo2\n");*/
    
    valuePresent = INTEGER( resultinR ); //plug the C pointer on the R type
	
        R_CheckStack();
	
        //computation step        
        pokerTest(rHands, nbh, dim, valuePresent);
	
        UNPROTECT(1);
	
        return resultinR;
}

//compute the observed hands
// r[i] is the number of hands with i+1 (different) value(s)
void pokerTest(int *hands, int nbh, int d, int *res)
{
        int i, j; //loop indexes
        int nbzero; //zero counter
        
        int * temp = (int *) R_alloc(d, sizeof(int) );
	
        if (!R_FINITE(nbh) || !R_FINITE(d))
                error(_("non finite argument"));
            
        //init
        for(j = 0; j < d; j++)
                res[j] = 0;
                   
        for(i = 0; i < nbh; i++) 
        {
                //erase previous line
                for(j = 0; j < d; j++)
                        temp[j] = 0;
            
                //browse the i+1th hand
                for(j = 0; j < d; j++)
                { 
                        //if(hands[i + j * nb] > -1 && hands[i + j * nb] <d)
                            temp[ hands[i + j * nbh] ] ++;
                        //else
                            //error(_("internal error in pokertest"));
                }
            /*
            Rprintf("temp : ");
            for(j = 0; j < d; j++)
                Rprintf(" %d\t", temp[j]);
            Rprintf("\n");
            */
                
                nbzero = 0;
            
                //find the i+1 th hand
                for(j = 0; j < d; j++)
                {
                        if(temp[j] == 0)
                                nbzero++;
                }
            //nb of different value is d-nbzero
            res[d - nbzero - 1] ++;
                    
        }
      
}



//main function used .Call()
SEXP doCollisionTest(SEXP num, SEXP n, SEXP m)
{
        if (!isNumeric(num) || !isNumeric(n) || !isNumeric(m))
            error(_("invalid argument"));
        
        
        //temporary working variables
        int lenSample  = asInteger( n ); //length of the sample 'num'
        int nbUrns = asInteger( m ); //number of urns
        
        int * rNum = INTEGER( num ); // vector of length n with random urn numbers
        
        int * Urns = (int *) R_alloc(nbUrns, sizeof(int));
        
        //result
        int *nbCollision = (int *) R_alloc(1, sizeof(int));
        SEXP resultinR; //result in R
        PROTECT(resultinR = allocVector(INTSXP, 1)); //allocate an integer
        /*
         if(resultinR == NULL) Rprintf("zog\n");
         else Rprintf("toooo2\n");*/
        
        nbCollision = INTEGER( resultinR ); //plug the C pointer on the R type
        
        R_CheckStack();
        
        //computation step        
        collisionTest(rNum, lenSample, nbUrns, Urns, nbCollision);
        
        UNPROTECT(1);
        
        return resultinR;
}

void collisionTest(int * num, int n, int m, int * urns, int * res)
{
        int i, j;
        
        //init array urns
        for(j = 0; j < m; j++)
                urns[j] = 0;
        //init number of collisions
        * res = 0;
    
        for(i = 0; i < n; i++)
        {
                if(urns[ num[ i ] ] != 0) //a collisions
                        (* res) ++;  
                
                //put the point in the urn
                urns[ num[ i ] ] ++;
        }
}
