% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expEndp.R
\name{expEndp}
\alias{expEndp}
\title{Representation of exponentially distributed endpoints}
\usage{
expEndp(lambda, cenRate, accrualTime = 0, cenTime)
}
\arguments{
\item{lambda}{vector of the exponential rate parameters in each treatment group.}

\item{cenRate}{exponential censoring rate in a survival study.}

\item{accrualTime}{duration of the accrual period in a survival study.}

\item{cenTime}{total duration of a survival study (maximum length of followup).}
}
\value{
A \code{S4} object representing
an exponentially distributed endpoint in a clinical trial.
}
\description{
Represents exponentially distributed endpoints in clinical trials.
}
\details{
The \code{expEnd} function is a constructor function
for an S4 object of the class \code{expEnd} representing
an exponentially distributed endpoint in a clinical trial.
In conjunction with the assess function, exponential endpoints
admit the calculation of the 'exact' type-I-error probability and power
using an approximation formula.
}
\examples{
# set the parameters of two exponentially distributed endpoints
endp <- expEndp(lambda = c(1, 2), cenTime = 10, cenRate = 0.01)

}
\seealso{
Compute exact or simulated type-I-error: \code{\link{assess}}.

Other endpoint types: 
\code{\link{normEndp}},
\code{\link{survEndp}}
}
\concept{endpoint types}
