% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assess.R
\docType{methods}
\name{assess}
\alias{assess}
\alias{assess,randSeq,endpoint-method}
\alias{assess,randSeq,missing-method}
\title{Assessing randomization sequences}
\usage{
assess(randSeq, ..., endp)

\S4method{assess}{randSeq,missing}(randSeq, ..., endp)

\S4method{assess}{randSeq,endpoint}(randSeq, ..., endp)
}
\arguments{
\item{randSeq}{object of class randSeq.}

\item{...}{at least one object of class issue.}

\item{endp}{object of class endpoint, or missing.}
}
\value{
\code{S4} object of class \code{assessment} summarizing the assessment of the
randomization procedure.
}
\description{
Assesses randomization sequences based on specified issues
in clinical trials.
}
\details{
Randomization sequences behave differently with respect to issues
like selection bias, chronological bias, or loss in power estimation.
The \code{assess} function evaluates the behaviour of randomization
sequences with respect to these issues.
The first argument should be a result of one of the functions
\code{\link{genSeq}} or \code{\link{getAllSeq}}.
The second argument should be any number of \code{\link{issues}} arising
in a clinical trial. The last argument \code{endp} may be provided if
the assessment should take the distribution of the treamtent groups
into account, e.g. for power evaluation.
}
\examples{
# assess the full set of Random Allocation Rule for N=4 patients
sequences <- getAllSeq(rarPar(4))
issue1 <- corGuess("CS")
issue2 <- corGuess("DS")
issue3 <- imbal("imb")
issue4 <- imbal("maxImb")
assess(sequences, issue1, issue2, issue3, issue4)

# assess one sequence of the Big Stick Design with respect to correct guesses
sequence <- genSeq(bsdPar(10, 2), seed = 1909)
assess(sequence, issue1)

# assess the same sequence with respect to selection bias
endp <- normEndp(c(2, 2), c(1, 1))
issue5 <- selBias("CS", 4, "exact")
issue6 <- setPower(2, "exact")
assess(sequence, issue1, issue5, issue6, endp = endp)
}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the assessment of randomization sequences
}

