% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_inference.R
\name{mpe_inference_from_stream}
\alias{mpe_inference_from_stream}
\title{Runs MPE inference from an AMIDST data stream}
\usage{
mpe_inference_from_stream(network, evidence_variables, input_stream,
  parallel = T, seed = 3L)
}
\arguments{
\item{network}{a java object of class \code{BayesianNetwork} over which the
computations will be carried out}

\item{evidence_variables}{a vector with the names of the observed variables}

\item{input_stream}{and AMIDST data stream}

\item{parallel}{a \code{boolean} indicating whether or not the items in the
sample will be generated in parallel (when allowed by the system)}

\item{seed}{the seed for the genertion of random numbers}
}
\value{
a \code{data.frame} with the MPE configuration
for each item in the stream
}
\description{
Runs MPE inference from an AMIDST data stream
}
\note{
The function computes the most probable explanation
of the evidence in all the items in the input stream.
}
\examples{
\dontrun{
network <- load_amidst_bn(system.file("extdata","WasteIncinerator.bn",
package="ramidst"))
sample_stream <- amidst_data_stream(system.file("extdata",
"WasteIncineratorSample.arff",package="ramidst"))
mpe_configurations <- mpe_inference_from_stream(network,c("E"),sample_stream)
mpe_configurations
}
}
\references{
D. Ramos-Lopez, A. Salmeron, R. Rumi, A.M.
Martinez, T.D. Nielsen, A.R. Masegosa, H. Langseth, A.L.
Madsen (2016) Scalable MAP inference in Bayesian networks based on a
Map-Reduce approach. PGM'2016. JMLR: Workshop and Conference Proceedings,
vol. 52: 415-425.
}

