/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.exponentialfamily;

import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.datastream.DynamicDataInstance;

public abstract class EF_DynamicDistribution {
    protected Variable var;
    protected NaturalParameters naturalParameters;
    protected MomentParameters momentParameters;

    public final Variable getVariable() {
        return this.var;
    }

    public final NaturalParameters getNaturalParameters() {
        return this.naturalParameters;
    }

    public final MomentParameters getMomentParameters() {
        return this.momentParameters;
    }

    public void setNaturalParameters(NaturalParameters parameters) {
        this.naturalParameters = parameters;
        this.updateMomentFromNaturalParameters();
    }

    public void setMomentParameters(SufficientStatistics parameters) {
        this.momentParameters = (MomentParameters)((Object)parameters);
        this.updateNaturalFromMomentParameters();
    }

    public void setMomentParameters(MomentParameters parameters) {
        this.momentParameters = parameters;
        this.updateNaturalFromMomentParameters();
    }

    public abstract void updateNaturalFromMomentParameters();

    public abstract void updateMomentFromNaturalParameters();

    public abstract SufficientStatistics getSufficientStatistics(DynamicDataInstance var1);

    public abstract int sizeOfSufficientStatistics();

    public abstract double computeLogBaseMeasure(DynamicDataInstance var1);

    public abstract double computeLogNormalizer();

    public double computeProbabilityOf(DynamicDataInstance dataInstance) {
        return Math.exp(this.computeLogProbabilityOf(dataInstance));
    }

    public double computeLogProbabilityOf(DynamicDataInstance dataInstance) {
        return this.naturalParameters.dotProduct(this.getSufficientStatistics(dataInstance)) + this.computeLogBaseMeasure(dataInstance) - this.computeLogNormalizer();
    }

    public abstract Vector createZeroVector();

    public MomentParameters createZeroMomentParameters() {
        return (MomentParameters)this.createZeroVector();
    }

    public SufficientStatistics createZeroSufficientStatistics() {
        return (SufficientStatistics)this.createZeroVector();
    }

    public NaturalParameters createZeroNaturalParameters() {
        return (NaturalParameters)this.createZeroVector();
    }

    public abstract SufficientStatistics createInitSufficientStatistics();
}

