/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import com.google.common.util.concurrent.AtomicDouble;
import eu.amidst.core.distribution.BaseDistribution_MultinomialParents;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Distribution;
import eu.amidst.core.exponentialfamily.EF_Multinomial;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.ParameterVariables;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EF_BaseDistribution_MultinomialParents<E extends EF_ConditionalDistribution>
extends EF_ConditionalDistribution {
    private final List<E> distributions;
    private final List<Variable> multinomialParents;
    private boolean isBaseConditionalDistribution;

    public EF_BaseDistribution_MultinomialParents(List<Variable> multinomialParents1, List<E> distributions1) {
        this(multinomialParents1, distributions1, true);
    }

    /*
     * WARNING - void declaration
     */
    public EF_BaseDistribution_MultinomialParents(List<Variable> multinomialParents1, List<E> distributions1, boolean initializeMomentNaturalParameters) {
        if (distributions1.size() == 0) {
            throw new IllegalArgumentException("Size of base distributions is zero");
        }
        int size = MultinomialIndex.getNumberOfPossibleAssignments(multinomialParents1);
        if (size != distributions1.size()) {
            throw new IllegalArgumentException("Size of base distributions list does not match with the number of parents configurations");
        }
        this.var = ((EF_ConditionalDistribution)distributions1.get(0)).getVariable();
        this.multinomialParents = multinomialParents1;
        this.distributions = distributions1;
        this.parents = new ArrayList();
        for (Variable variable : this.multinomialParents) {
            this.parents.add(variable);
        }
        if (this.distributions.get(0) instanceof EF_ConditionalDistribution) {
            this.isBaseConditionalDistribution = true;
            for (int i = 0; i < size; ++i) {
                for (Variable v : this.getBaseEFConditionalDistribution(i).getConditioningVariables()) {
                    if (this.parents.contains(v)) continue;
                    this.parents.add(v);
                }
            }
        } else {
            this.isBaseConditionalDistribution = false;
        }
        this.naturalParameters = null;
        this.momentParameters = null;
        if (initializeMomentNaturalParameters) {
            void var6_12;
            CompoundVector vectorNatural = this.createCompoundVector();
            boolean bl = false;
            while (var6_12 < this.numberOfConfigurations()) {
                vectorNatural.setBaseConf((int)var6_12, -((EF_Distribution)this.getBaseEFDistribution((int)var6_12)).computeLogNormalizer());
                vectorNatural.setVectorByPosition((int)var6_12, ((EF_Distribution)this.getBaseEFDistribution((int)var6_12)).getNaturalParameters());
                ++var6_12;
            }
            this.naturalParameters = vectorNatural;
        }
    }

    public List<Variable> getMultinomialParents() {
        return this.multinomialParents;
    }

    public boolean isBaseConditionalDistribution() {
        return this.isBaseConditionalDistribution;
    }

    public EF_ConditionalDistribution getBaseEFConditionalDistribution(int multinomialIndex) {
        return this.getBaseEFDistribution(multinomialIndex);
    }

    public EF_UnivariateDistribution getBaseEFUnivariateDistribution(int multinomialIndex) {
        return (EF_UnivariateDistribution)this.getBaseEFDistribution(multinomialIndex);
    }

    public void setBaseEFDistribution(int indexMultinomial, E baseDist) {
        this.distributions.set(indexMultinomial, baseDist);
    }

    public E getBaseEFDistribution(int indexMultinomial) {
        return (E)((EF_ConditionalDistribution)this.distributions.get(indexMultinomial));
    }

    public int numberOfConfigurations() {
        return this.distributions.size();
    }

    public int sizeOfBaseSufficientStatistics() {
        return ((EF_Distribution)this.getBaseEFDistribution(0)).sizeOfSufficientStatistics();
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment instance) {
        CompoundVector vector = this.createCompoundVector();
        int position = MultinomialIndex.getIndexFromVariableAssignment(this.multinomialParents, instance);
        vector.setBaseConf(position, 1.0);
        SufficientStatistics sufficientStatisticsBase = ((EF_Distribution)this.getBaseEFDistribution(position)).getSufficientStatistics(instance);
        vector.setVectorByPosition(position, sufficientStatisticsBase);
        return vector;
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return this.numberOfConfigurations() + this.numberOfConfigurations() * this.sizeOfBaseSufficientStatistics();
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        CompoundVector globalMomentsParam = (CompoundVector)this.momentParameters;
        for (int i = 0; i < this.numberOfConfigurations(); ++i) {
            MomentParameters moment = (MomentParameters)globalMomentsParam.getVectorByPosition(i);
            moment.divideBy(globalMomentsParam.getBaseConf(i));
            ((EF_Distribution)this.getBaseEFDistribution(i)).setMomentParameters(moment);
        }
        CompoundVector vectorNatural = this.createCompoundVector();
        for (int i = 0; i < this.numberOfConfigurations(); ++i) {
            vectorNatural.setBaseConf(i, -((EF_Distribution)this.getBaseEFDistribution(i)).computeLogNormalizer());
            vectorNatural.setVectorByPosition(i, ((EF_Distribution)this.getBaseEFDistribution(i)).getNaturalParameters());
        }
        this.naturalParameters = vectorNatural;
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        int position = MultinomialIndex.getIndexFromVariableAssignment(this.multinomialParents, dataInstance);
        return ((EF_Distribution)this.getBaseEFDistribution(position)).computeLogBaseMeasure(dataInstance);
    }

    @Override
    public double computeLogNormalizer() {
        return 0.0;
    }

    @Override
    public Vector createZeroVector() {
        return this.createCompoundVector();
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        CompoundVector vector = this.createCompoundVector();
        for (int i = 0; i < this.numberOfConfigurations(); ++i) {
            SufficientStatistics vec = ((EF_Distribution)this.getBaseEFDistribution(i)).createInitSufficientStatistics();
            vector.setBaseConf(i, 1.0 / (double)this.numberOfConfigurations());
            vec.multiplyBy(1.0 / (double)this.numberOfConfigurations());
            vector.setVectorByPosition(i, vec);
        }
        return vector;
    }

    @Override
    public double getExpectedLogNormalizer(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        return 0.0;
    }

    @Override
    public double getExpectedLogNormalizer(Map<Variable, MomentParameters> momentParents) {
        int nConf = MultinomialIndex.getNumberOfPossibleAssignments(this.multinomialParents);
        double expectedLogNormalizer = 0.0;
        for (int i = 0; i < nConf; ++i) {
            double[] assignment = MultinomialIndex.getVariableArrayAssignmentFromIndex(this.multinomialParents, i);
            double momentValue = 1.0;
            for (int j = 0; j < assignment.length; ++j) {
                momentValue *= momentParents.get(this.multinomialParents.get(j)).get((int)assignment[j]);
            }
            if (momentValue == 0.0) continue;
            double partialLogNormalizer = 0.0;
            partialLogNormalizer = this.isBaseConditionalDistribution ? this.getBaseEFConditionalDistribution(i).getExpectedLogNormalizer(momentParents) : this.getBaseEFUnivariateDistribution(i).computeLogNormalizer();
            expectedLogNormalizer += momentValue * partialLogNormalizer;
        }
        return expectedLogNormalizer;
    }

    @Override
    public NaturalParameters getExpectedNaturalFromParents(Map<Variable, MomentParameters> momentParents) {
        int nConf = MultinomialIndex.getNumberOfPossibleAssignments(this.multinomialParents);
        NaturalParameters expectedNaturalFromParents = null;
        for (int i = 0; i < nConf; ++i) {
            double[] assignment = MultinomialIndex.getVariableArrayAssignmentFromIndex(this.multinomialParents, i);
            double momentValue = 1.0;
            for (int j = 0; j < assignment.length; ++j) {
                momentValue *= momentParents.get(this.multinomialParents.get(j)).get((int)assignment[j]);
            }
            NaturalParameters paritalExpectedNatural = null;
            if (this.isBaseConditionalDistribution) {
                paritalExpectedNatural = this.getBaseEFConditionalDistribution(i).getExpectedNaturalFromParents(momentParents);
            } else {
                paritalExpectedNatural = this.getBaseEFUnivariateDistribution(i).createZeroNaturalParameters();
                paritalExpectedNatural.copy(this.getBaseEFUnivariateDistribution(i).getNaturalParameters());
            }
            paritalExpectedNatural.multiplyBy(momentValue);
            if (expectedNaturalFromParents == null) {
                expectedNaturalFromParents = paritalExpectedNatural;
                continue;
            }
            expectedNaturalFromParents.sum(paritalExpectedNatural);
        }
        return expectedNaturalFromParents;
    }

    @Override
    public NaturalParameters getExpectedNaturalToParent(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        NaturalParameters expectedNaturalToParents = null;
        int indexOfMultinomialParent = this.multinomialParents.indexOf(parent);
        if (indexOfMultinomialParent == -1 && parent.isMultinomial()) {
            throw new IllegalArgumentException("Parent Variable is multinomial and not included in the list of multinomial parents: " + parent.getName());
        }
        if (indexOfMultinomialParent != -1) {
            expectedNaturalToParents = new EF_Multinomial(parent).createZeroNaturalParameters();
            int nConf = MultinomialIndex.getNumberOfPossibleAssignments(this.multinomialParents);
            for (int state = 0; state < parent.getNumberOfStates(); ++state) {
                double partialSum = 0.0;
                for (int i = 0; i < nConf; ++i) {
                    double[] assignment = MultinomialIndex.getVariableArrayAssignmentFromIndex(this.multinomialParents, i);
                    if (assignment[indexOfMultinomialParent] != (double)state) continue;
                    double momentValue = 1.0;
                    for (int j = 0; j < assignment.length; ++j) {
                        if (j == indexOfMultinomialParent) continue;
                        momentValue *= momentChildCoParents.get(this.multinomialParents.get(j)).get((int)assignment[j]);
                    }
                    NaturalParameters paritalExpectedNatural = null;
                    double localSum = 0.0;
                    if (this.isBaseConditionalDistribution) {
                        localSum = this.getBaseEFConditionalDistribution(i).computeLogProbability(momentChildCoParents);
                    } else {
                        paritalExpectedNatural = this.getBaseEFUnivariateDistribution(i).createZeroNaturalParameters();
                        paritalExpectedNatural.copy(this.getBaseEFUnivariateDistribution(i).getNaturalParameters());
                        localSum += paritalExpectedNatural.dotProduct(momentChildCoParents.get(this.getVariable()));
                        localSum -= this.getBaseEFUnivariateDistribution(i).computeLogNormalizer();
                    }
                    if (Double.isNaN(momentValue) || Double.isNaN(localSum) || Double.isNaN(partialSum)) {
                        throw new IllegalStateException("NAN VALUE!");
                    }
                    partialSum += (localSum *= momentValue);
                }
                expectedNaturalToParents.set(state, partialSum);
            }
        } else {
            if (!this.isBaseConditionalDistribution()) {
                throw new IllegalArgumentException("Parent Variable is no multinomial and based distribution has no parents");
            }
            if (!this.parents.contains(parent)) {
                throw new IllegalArgumentException("Parent Variable is no multinomial and is not included in the list of parents of the base distribution");
            }
            int nConf = MultinomialIndex.getNumberOfPossibleAssignments(this.multinomialParents);
            for (int i = 0; i < nConf; ++i) {
                if (!this.getBaseEFConditionalDistribution(i).getConditioningVariables().contains(parent)) continue;
                double[] assignment = MultinomialIndex.getVariableArrayAssignmentFromIndex(this.multinomialParents, i);
                double momentValue = 1.0;
                for (int j = 0; j < assignment.length; ++j) {
                    momentValue *= momentChildCoParents.get(this.multinomialParents.get(j)).get((int)assignment[j]);
                }
                NaturalParameters paritalExpectedNatural = null;
                if (this.isBaseConditionalDistribution) {
                    paritalExpectedNatural = this.getBaseEFConditionalDistribution(i).getExpectedNaturalToParent(parent, momentChildCoParents);
                } else {
                    paritalExpectedNatural = this.getBaseEFUnivariateDistribution(i).createZeroNaturalParameters();
                    paritalExpectedNatural.copy(this.getBaseEFUnivariateDistribution(i).getNaturalParameters());
                }
                paritalExpectedNatural.multiplyBy(momentValue);
                if (expectedNaturalToParents == null) {
                    expectedNaturalToParents = paritalExpectedNatural;
                    continue;
                }
                expectedNaturalToParents.sum(paritalExpectedNatural);
            }
        }
        return expectedNaturalToParents;
    }

    @Override
    public List<EF_ConditionalDistribution> toExtendedLearningDistribution(ParameterVariables parameters, String nameSuffix) {
        if (this.getConditioningVariables().size() == 0) {
            return ((EF_Distribution)this.getBaseEFDistribution(0)).toExtendedLearningDistribution(parameters);
        }
        ArrayList<EF_ConditionalDistribution> totalDists = new ArrayList<EF_ConditionalDistribution>();
        for (int i = 0; i < this.distributions.size(); ++i) {
            Assignment assignment = MultinomialIndex.getVariableAssignmentFromIndex(this.multinomialParents, i);
            String conf = assignment.outputString(this.multinomialParents);
            totalDists.addAll(((EF_ConditionalDistribution)this.distributions.get(i)).toExtendedLearningDistribution(parameters, nameSuffix + conf));
        }
        List dist_NoParameter = totalDists.stream().filter(dist -> !dist.getVariable().isParameterVariable()).collect(Collectors.toList());
        List<EF_ConditionalDistribution> dist_Parameter = totalDists.stream().filter(dist -> dist.getVariable().isParameterVariable()).collect(Collectors.toList());
        EF_BaseDistribution_MultinomialParents base = new EF_BaseDistribution_MultinomialParents(this.multinomialParents, dist_NoParameter, false);
        dist_Parameter.add(base);
        return dist_Parameter;
    }

    @Override
    public <E extends ConditionalDistribution> E toConditionalDistribution() {
        BaseDistribution_MultinomialParents base = new BaseDistribution_MultinomialParents(this.var, this.getConditioningVariables());
        if (this.isBaseConditionalDistribution()) {
            for (int i = 0; i < this.numberOfConfigurations(); ++i) {
                base.setBaseDistribution(i, this.getBaseEFConditionalDistribution(i).toConditionalDistribution());
            }
        } else {
            for (int i = 0; i < this.numberOfConfigurations(); ++i) {
                base.setBaseDistribution(i, this.getBaseEFUnivariateDistribution(i).toUnivariateDistribution());
            }
        }
        return DistributionTypeEnum.FromBaseDistributionToConditionalDistribution(base);
    }

    private CompoundVector createCompoundVector() {
        return new CompoundVector((EF_Distribution)this.getBaseEFDistribution(0), this.numberOfConfigurations());
    }

    @Override
    public ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables) {
        ArrayList distributionList = new ArrayList();
        for (EF_Distribution dist : this.distributions) {
            EF_ConditionalDistribution learningDistribution = (EF_ConditionalDistribution)dist;
            ConditionalDistribution conditionalDistribution = learningDistribution.toConditionalDistribution(expectedValueParameterVariables);
            if (conditionalDistribution instanceof BaseDistribution_MultinomialParents) {
                BaseDistribution_MultinomialParents base = (BaseDistribution_MultinomialParents)conditionalDistribution;
                distributionList.add(base.getBaseDistribution(0));
                continue;
            }
            distributionList.add(conditionalDistribution);
        }
        return DistributionTypeEnum.FromBaseDistributionToConditionalDistribution(new BaseDistribution_MultinomialParents(this.multinomialParents, distributionList));
    }

    private static interface VectorBuilder {
        public Vector createZeroedVector();
    }

    private static class SparseVector
    implements Vector,
    Serializable {
        private static final long serialVersionUID = -3436599636425587512L;
        EF_Distribution vectorBuilder;
        Map<Integer, Vector> vectorMap;
        int numVectors;
        int baseSize;
        int nonZeroEntries;

        public SparseVector(EF_Distribution vectorBuilder1, int numVectors1) {
            this.vectorBuilder = vectorBuilder1;
            Vector baseVector = this.vectorBuilder.createZeroVector();
            this.baseSize = baseVector.size();
            this.numVectors = numVectors1;
            this.nonZeroEntries = 0;
            this.vectorMap = new ConcurrentHashMap<Integer, Vector>();
        }

        public void setVectorByPosition(int position, Vector vec) {
            if (this.vectorMap.containsKey(position)) {
                this.vectorMap.put(position, vec);
            } else {
                this.vectorMap.put(position, vec);
                ++this.nonZeroEntries;
            }
        }

        public Vector getVectorByPosition(int position) {
            return this.vectorMap.get(position);
        }

        public int getNumberNonZeroEntries() {
            return this.nonZeroEntries;
        }

        @Override
        public double get(int i) {
            int baseIndex = Math.floorDiv(i, this.baseSize);
            if (this.vectorMap.containsKey(baseIndex)) {
                return this.vectorMap.get(baseIndex).get(i % this.baseSize);
            }
            return 0.0;
        }

        @Override
        public void set(int i, double val) {
            int baseIndex = Math.floorDiv(i, this.baseSize);
            if (this.vectorMap.containsKey(baseIndex)) {
                this.vectorMap.get(baseIndex).set(i % this.baseSize, val);
            } else {
                Vector baseVector = this.vectorBuilder.createZeroVector();
                baseVector.set(i % this.baseSize, val);
                this.vectorMap.put(baseIndex, baseVector);
                ++this.nonZeroEntries;
            }
        }

        @Override
        public int size() {
            return this.baseSize * this.numVectors;
        }

        @Override
        public void sum(Vector vector) {
            this.sum((SparseVector)vector);
        }

        public void sum(SparseVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size.");
            }
            vector.nonZeroEntries().forEach(entry -> {
                Vector localVector = this.getVectorByPosition((Integer)entry.getKey());
                Vector outerVector = (Vector)entry.getValue();
                if (localVector != null) {
                    localVector.sum(outerVector);
                } else {
                    Vector newVector = this.vectorBuilder.createZeroVector();
                    newVector.sum(outerVector);
                    this.setVectorByPosition((Integer)entry.getKey(), newVector);
                }
            });
        }

        @Override
        public void copy(Vector vector) {
            this.copy((SparseVector)vector);
        }

        public void copy(SparseVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size. ");
            }
            this.vectorMap = new ConcurrentHashMap<Integer, Vector>();
            vector.nonZeroEntries().forEach(entry -> {
                Vector newVector = this.vectorBuilder.createZeroVector();
                newVector.copy((Vector)entry.getValue());
                this.setVectorByPosition((Integer)entry.getKey(), newVector);
            });
        }

        @Override
        public void divideBy(double val) {
            this.nonZeroEntries().forEach(entry -> ((Vector)entry.getValue()).divideBy(val));
        }

        @Override
        public double dotProduct(Vector vec) {
            return this.dotProduct((SparseVector)vec);
        }

        public double dotProduct(SparseVector vec) {
            AtomicDouble sum = new AtomicDouble(0.0);
            if (this.getNumberNonZeroEntries() < vec.getNumberNonZeroEntries()) {
                this.nonZeroEntries().forEach(entry -> {
                    Vector outerVector = vec.getVectorByPosition((Integer)entry.getKey());
                    if (outerVector != null) {
                        sum.addAndGet(outerVector.dotProduct((Vector)entry.getValue()));
                    }
                });
            } else {
                vec.nonZeroEntries().forEach(entry -> {
                    Vector localVector = this.getVectorByPosition((Integer)entry.getKey());
                    if (localVector != null) {
                        sum.addAndGet(localVector.dotProduct((Vector)entry.getValue()));
                    }
                });
            }
            return sum.doubleValue();
        }

        public Stream<Map.Entry<Integer, Vector>> nonZeroEntries() {
            return this.vectorMap.entrySet().stream();
        }
    }

    private static class CompoundVector
    implements SufficientStatistics,
    MomentParameters,
    NaturalParameters,
    Serializable {
        private static final long serialVersionUID = -3436599636425587512L;
        int nConf;
        int baseSSLength;
        double[] baseConf;
        EF_Distribution baseDist;
        SparseVector baseVectors;

        public CompoundVector(EF_Distribution baseDist1, int nConf1) {
            this.nConf = nConf1;
            this.baseConf = new double[this.nConf];
            this.baseDist = baseDist1;
            this.baseVectors = new SparseVector(baseDist1, this.nConf);
            this.baseSSLength = this.baseDist.sizeOfSufficientStatistics();
        }

        public void setVectorByPosition(int position, Vector vec) {
            this.baseVectors.setVectorByPosition(position, vec);
        }

        public Vector getVectorByPosition(int position) {
            Vector vector = this.baseVectors.getVectorByPosition(position);
            if (vector == null) {
                return this.baseDist.createZeroVector();
            }
            return vector;
        }

        public double getBaseConf(int i) {
            return this.baseConf[i];
        }

        public void setBaseConf(int i, double val) {
            this.baseConf[i] = val;
        }

        @Override
        public double get(int i) {
            if (i < this.nConf) {
                return this.baseConf[i];
            }
            return this.baseVectors.get(i -= this.nConf);
        }

        @Override
        public void set(int i, double val) {
            if (i < this.nConf) {
                this.baseConf[i] = val;
            } else {
                this.baseVectors.set(i -= this.nConf, val);
            }
        }

        @Override
        public int size() {
            return this.nConf + this.nConf * this.baseSSLength;
        }

        @Override
        public void sum(Vector vector) {
            this.sum((CompoundVector)vector);
        }

        public SparseVector getBaseVectors() {
            return this.baseVectors;
        }

        public void sum(CompoundVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size.");
            }
            for (int i = 0; i < this.baseConf.length; ++i) {
                int n = i;
                this.baseConf[n] = this.baseConf[n] + vector.getBaseConf(i);
            }
            this.baseVectors.sum(vector.getBaseVectors());
        }

        @Override
        public void copy(Vector vector) {
            this.copy((CompoundVector)vector);
        }

        public void copy(CompoundVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size.");
            }
            System.arraycopy(vector.baseConf, 0, this.baseConf, 0, this.nConf);
            this.baseVectors.copy(vector.getBaseVectors());
        }

        @Override
        public void divideBy(double val) {
            int i = 0;
            while (i < this.baseConf.length) {
                int n = i++;
                this.baseConf[n] = this.baseConf[n] / val;
            }
            this.baseVectors.divideBy(val);
        }

        @Override
        public double dotProduct(Vector vector) {
            return this.dotProduct((CompoundVector)vector);
        }

        public double dotProduct(CompoundVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size.");
            }
            double sum = 0.0;
            for (int i = 0; i < this.baseConf.length; ++i) {
                sum += this.baseConf[i] * vector.getBaseConf(i);
            }
            return sum += this.baseVectors.dotProduct(vector.getBaseVectors());
        }
    }
}

