% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term_structures.R
\name{variance_cumulation_from_vols}
\alias{variance_cumulation_from_vols}
\title{Create a variance cumulation function from a volatility term structure}
\usage{
variance_cumulation_from_vols(vols_df)
}
\arguments{
\item{vols_df}{A data.frame with numeric columns \code{time} (in
increasing order) and \code{volatility} (not decreasing so quickly
as to give negative forward variance)}
}
\value{
A function taking two time arguments, which returns the cumulated
  variance from the second to the first
}
\description{
Given a volatility term structure, create a corresponding variance
  cumulation function.  The function assumes piecewise constant
  forward volatility, with the final such forward volatility
  extending to infinity.
}
\examples{
vc = variance_cumulation_from_vols(
  data.frame(time=c(0.1,2,3),
  volatility=c(0.2,0.5,1.2)))
vc(1.5, 0)

}

