% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackscholes.R
\name{black_scholes_on_term_structures}
\alias{black_scholes_on_term_structures}
\title{Black-Scholes pricing of european-exercise options with term structure arguments}
\usage{
black_scholes_on_term_structures(callput, S0, K, time, const_volatility = 0.5,
  const_short_rate = 0, const_default_intensity = 0,
  discount_factor_fcn = function(T, t, ...) {     exp(-const_short_rate * (T -
  t)) }, survival_probability_fcn = function(T, t, ...) {    
  exp(-const_default_intensity * (T - t)) },
  variance_cumulation_fcn = function(T, t) {     const_volatility^2 * (T - t)
  }, dividends = NULL, borrow_cost = 0, dividend_rate = 0)
}
\arguments{
\item{callput}{1 for calls, -1 for puts}

\item{S0}{initial underlying price}

\item{K}{strike}

\item{time}{Time from \code{0} until expiration}

\item{const_volatility}{A constant to use for volatility in case \code{variance_cumulation_fcn}
is not given}

\item{const_short_rate}{A constant to use for the instantaneous interest rate in case \code{discount_factor_fcn}
is not given}

\item{const_default_intensity}{A constant to use for the instantaneous default intensity in case \code{default_intensity_fcn}
is not given}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{survival_probability_fcn}{A function for probability of survival, with
arguments \code{T}, \code{t} and \code{T>t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{variance_cumulation_fcn}{A function for computing total stock variance
occurring during this timestep, with arguments \code{T}, \code{t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}.  Fixed
dividends will be converted to proportional for purposes of this algorithm.}

\item{borrow_cost}{A continuous rate for stock borrow costs}

\item{dividend_rate}{A continuous rate for dividends and other cashflows such as foreign interest rates}
}
\description{
Price an option according to the famous Black-Scholes formula, with the
optional addition of a jump-to-default intensity and discrete dividends.  Volatility
and rates may be provided as constants or as 2+ parameter functions with
first argument \code{T} corresponding to maturity and second argument \code{t} corresponding to
model date.
}
\details{
Any term structures will be converted to equivalent constant arguments by calling
them with the arguments \code{(time, 0)}.
}
\examples{
black_scholes_on_term_structures(callput=-1, S0=100, K=90, time=1,
                                 discount_factor_fcn = function(T, t, ...) {
                                   exp(-0.03 * (T - t))
                                 },
                                 survival_probability_fcn = function(T, t, ...) {
                                   exp(-0.07 * (T - t))
                                 },
                                 variance_cumulation_fcn = function(T, t) {
                                   0.45 ^ 2 * (T - t)
                                 })
}
\seealso{
Other Equity Independent Default Intensity: \code{\link{american_implied_volatility}},
  \code{\link{american}}, \code{\link{blackscholes}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other European Options: \code{\link{blackscholes}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}
}

