% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{plot.mds}
\alias{plot.mds}
\title{Plot method for the mds function}
\usage{
\method{plot}{mds}(x, rev_dim = NULL, fontsz = 5, shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{mds}}}

\item{rev_dim}{Flip the axes in plots}

\item{fontsz}{Font size to use in plots}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the mds function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/mds.html} for an example in Radiant
}
\examples{
result <- mds(city, "from", "to", "distance")
plot(result, fontsz = 7)
plot(result, rev_dim = 1:2)

}
\seealso{
\code{\link{mds}} to calculate results

\code{\link{summary.mds}} to plot results
}
