% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\name{sensitivity.dtree}
\alias{sensitivity.dtree}
\title{Evaluate sensitivity of the decision tree}
\usage{
\method{sensitivity}{dtree}(
  object,
  vars = NULL,
  decs = NULL,
  envir = parent.frame(),
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{object}{Return value from \code{\link{dtree}}}

\item{vars}{Variables to include in the sensitivity analysis}

\item{decs}{Decisions to include in the sensitivity analysis}

\item{envir}{Environment to extract data from}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{Additional arguments}
}
\description{
Evaluate sensitivity of the decision tree
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/dtree.html} for an example in Radiant
}
\examples{
dtree(movie_contract, opt = "max") \%>\%
  sensitivity(
    vars = "legal fees 0 100000 10000",
    decs = c("Sign with Movie Company", "Sign with TV Network"),
    custom = FALSE
  )

}
\seealso{
\code{\link{dtree}} to generate the result

\code{\link{plot.dtree}} to summarize results

\code{\link{summary.dtree}} to summarize results
}
