% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{var_check}
\alias{var_check}
\title{Check if main effects for all interaction effects are included in the model
If ':' is used to select a range _evar_ is updated}
\usage{
var_check(ev, cn, intv = "")
}
\arguments{
\item{ev}{List of explanatory variables provided to _regress_ or _logistic_}

\item{cn}{Column names for all explanatory variables in _dat_}

\item{intv}{Interaction terms specified}
}
\value{
'vars' is a vector of right-hand side variables, possibly with interactions, 'iv' is the list of explanatory variables, and intv are interaction terms
}
\description{
Check if main effects for all interaction effects are included in the model
If ':' is used to select a range _evar_ is updated
}
\details{
See \url{http://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
var_check("a:d", c("a","b","c","d"))
var_check(c("a", "b"), c("a", "b"), "a:c")

}

