% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_readme.R
\name{write_readme}
\alias{write_readme}
\title{Create a project README file}
\usage{
write_readme(path = here::here())
}
\arguments{
\item{path}{The destination directory for the README file. Defaults to \code{
here::here()}.}
}
\value{
Creates a comprehensive README template for project documentation.
}
\description{
This function streamlines project documentation by creating and managing a README.md
file. It provides interactive prompts for existing files and maintains consistent 
project documentation structure.
}
\details{
The README.md template includes structured sections for:
\itemize{
  \item Project description (study name, principal investigator, author)
  \item Project setup steps for reproducibility
  \item File and directory descriptions
  \item Miscellaneous project notes
}

If the README file already exists, the function will stop and warn the user. The 
templates include example documentation that can be modified to suit project needs.
}
\examples{
# Create new README in temporary directory
tmp <- tempdir()
write_readme(path = tmp)
}
