/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import java.util.LinkedList;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineInfoPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusComposite;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;

public class CmdLineStatuses {
    private CmdLineInfoPart[] cmdLineInfoParts;
    private CmdLineStatusPart[] cmdLineStatusParts;
    private ISVNStatus[] cmdLineStatuses;

    CmdLineStatuses(String string, CmdLineStatusPart[] cmdLineStatusPartArray) {
        this.cmdLineStatusParts = cmdLineStatusPartArray;
        if (string.length() == 0) {
            this.cmdLineInfoParts = new CmdLineInfoPart[0];
        } else {
            String[] stringArray = CmdLineInfoPart.parseInfoParts(string);
            this.cmdLineInfoParts = new CmdLineInfoPart[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.cmdLineInfoParts[i] = new CmdLineInfoPart(stringArray[i]);
            }
        }
        this.cmdLineStatuses = this.buildStatuses();
    }

    CmdLineStatuses(CmdLineInfoPart[] cmdLineInfoPartArray, CmdLineStatusPart[] cmdLineStatusPartArray) {
        this.cmdLineInfoParts = cmdLineInfoPartArray;
        this.cmdLineStatusParts = cmdLineStatusPartArray;
        this.cmdLineStatuses = this.buildStatuses();
    }

    private ISVNStatus[] buildStatuses() {
        LinkedList<ISVNStatus> linkedList = new LinkedList<ISVNStatus>();
        for (int i = 0; i < this.cmdLineStatusParts.length; ++i) {
            CmdLineStatusPart cmdLineStatusPart = this.cmdLineStatusParts[i];
            File file = cmdLineStatusPart.getFile();
            if (cmdLineStatusPart == null || !cmdLineStatusPart.isManaged()) {
                boolean bl = false;
                if (cmdLineStatusPart != null) {
                    bl = SVNStatusKind.IGNORED.equals(cmdLineStatusPart.getTextStatus());
                }
                linkedList.add(new SVNStatusUnversioned(file, bl));
                continue;
            }
            CmdLineInfoPart cmdLineInfoPart = this.getCorrespondingInfoPart(file);
            if (cmdLineInfoPart == null) continue;
            linkedList.add(new CmdLineStatusComposite(cmdLineStatusPart, cmdLineInfoPart));
        }
        return linkedList.toArray(new ISVNStatus[linkedList.size()]);
    }

    private CmdLineInfoPart getCorrespondingInfoPart(File file) {
        for (int i = 0; i < this.cmdLineInfoParts.length; ++i) {
            if (!file.equals(this.cmdLineInfoParts[i].getFile())) continue;
            return this.cmdLineInfoParts[i];
        }
        return null;
    }

    public ISVNStatus get(int n) {
        return this.cmdLineStatuses[n];
    }

    public int size() {
        return this.cmdLineStatuses.length;
    }

    public ISVNStatus[] toArray() {
        return this.cmdLineStatuses;
    }
}

