/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

public class SVNNodeKind {
    private int kind;
    private static final int none = 0;
    private static final int file = 1;
    private static final int dir = 2;
    private static final int unknown = 3;
    public static final SVNNodeKind NONE = new SVNNodeKind(0);
    public static final SVNNodeKind FILE = new SVNNodeKind(1);
    public static final SVNNodeKind DIR = new SVNNodeKind(2);
    public static final SVNNodeKind UNKNOWN = new SVNNodeKind(3);

    private SVNNodeKind(int n) {
        this.kind = n;
    }

    public int toInt() {
        return this.kind;
    }

    public static SVNNodeKind fromInt(int n) {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return FILE;
            }
            case 2: {
                return DIR;
            }
            case 3: {
                return UNKNOWN;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "none";
            }
            case 1: {
                return "file";
            }
            case 2: {
                return "directory";
            }
            case 3: {
                return "unknown";
            }
        }
        return "";
    }

    public static SVNNodeKind fromString(String string) {
        if (NONE.toString().equals(string)) {
            return NONE;
        }
        if (FILE.toString().equals(string)) {
            return FILE;
        }
        if (DIR.toString().equals(string)) {
            return DIR;
        }
        if (UNKNOWN.toString().equals(string)) {
            return UNKNOWN;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SVNNodeKind)) {
            return false;
        }
        return ((SVNNodeKind)object).kind == this.kind;
    }

    public int hashCode() {
        return new Integer(this.kind).hashCode();
    }
}

