/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.PackageRemapper;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.commons.EmptyVisitor;
import com.tonicsystems.jarjar.asm.commons.Remapper;
import com.tonicsystems.jarjar.asm.commons.RemappingClassAdapter;
import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class KeepProcessor
extends Remapper
implements JarProcessor {
    private final ClassVisitor cv = new RemappingClassAdapter(new EmptyVisitor(), this);
    private final Wildcard[] wildcards;
    private final List roots = new ArrayList();
    private final Map depend = new HashMap();
    private Set curSet;
    private byte[] buf = new byte[8192];

    public KeepProcessor(List patterns) {
        this.wildcards = PatternElement.createWildcards(patterns);
    }

    public boolean isEnabled() {
        return this.wildcards.length > 0;
    }

    public Set getExcludes() {
        HashSet closure = new HashSet();
        this.closureHelper(closure, this.roots);
        HashSet removable = new HashSet(this.depend.keySet());
        removable.removeAll(closure);
        return removable;
    }

    private void closureHelper(Set closure, Collection process) {
        if (process == null) {
            return;
        }
        for (String name : process) {
            if (!closure.add(name)) continue;
            this.closureHelper(closure, (Collection)this.depend.get(name));
        }
    }

    public boolean process(EntryStruct struct) throws IOException {
        try {
            if (struct.name.endsWith(".class")) {
                String name = struct.name.substring(0, struct.name.length() - 6);
                for (int i = 0; i < this.wildcards.length; ++i) {
                    if (!this.wildcards[i].matches(name)) continue;
                    this.roots.add(name);
                }
                this.curSet = new HashSet();
                this.depend.put(name, this.curSet);
                NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
                IoUtils.pipe(struct.in, out, this.buf);
                new ClassReader(out.getInputStream()).accept(this.cv, 0);
                this.curSet.remove(name);
                struct.in = out.getInputStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected String map(String key) {
        if (key.startsWith("java/") || key.startsWith("javax/")) {
            return null;
        }
        this.curSet.add(key);
        return null;
    }

    public Object mapValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (PackageRemapper.isArrayForName(s)) {
                this.mapDesc(s.replace('.', '/'));
            } else if (KeepProcessor.isForName(s)) {
                this.map(s.replace('.', '/'));
            }
            return value;
        }
        return super.mapValue(value);
    }

    private static boolean isForName(String value) {
        if (value.equals("")) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private NoCopyByteArrayOutputStream() {
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

