% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safely_select_variables.R
\name{safely_select_variables}
\alias{safely_select_variables}
\title{Performing Feature Selection on the Dataset with Transformed Variables}
\usage{
safely_select_variables(
  safe_extractor,
  data,
  y = NULL,
  which_y = NULL,
  class_pred = NULL,
  verbose = TRUE
)
}
\arguments{
\item{safe_extractor}{object containing information about variables transformations created with safe_extraction() function}

\item{data}{data, original dataset or the one returned by safely_transform_data() function.
If data do not contain transformed variables then transformation is done inside this function using 'safe_extractor' argument.
Data may contain response variable or not - if it does then 'which_y' argument must be given,
otherwise 'y' argument should be provided.}

\item{y}{vector of responses, must be given if data does not contain it}

\item{which_y}{numeric or character (optional), must be given if data contains response values}

\item{class_pred}{numeric or character, used only in multi-classification problems.
If response vector has more than two levels, then 'class_pred' should indicate the class of interest
which will denote failure - all other classes will stand for success.}

\item{verbose}{logical, if progress bar is to be printed}
}
\value{
vector of variables names, selected based on AIC values
}
\description{
The safely_select_variables() function selects variables from dataset returned
by safely_transform_data() function. For each original variable exactly one variable is chosen
\itemize{
\item either original one or transformed one. The choice is based on the AIC value
for linear model (regression) or logistic regression (classification).
}
}
\examples{

library(DALEX)
library(randomForest)
library(rSAFE)

data <- apartments[1:500,]
set.seed(111)
model_rf <- randomForest(m2.price ~ construction.year + surface + floor +
                           no.rooms + district, data = data)
explainer_rf <- explain(model_rf, data = data[,2:6], y = data[,1])
safe_extractor <- safe_extraction(explainer_rf, verbose = FALSE)
safely_select_variables(safe_extractor, data, which_y = "m2.price", verbose = FALSE)

}
\seealso{
\code{\link{safely_transform_data}}
}
