% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.repairContinuity}
\alias{tg.repairContinuity}
\title{tg.repairContinuity}
\usage{
tg.repairContinuity(tg, verbose = TRUE)
}
\arguments{
\item{tg}{TextGrid object}

\item{verbose}{[optional, default=TRUE] If FALSE, the function performs everything quietly.}
}
\value{
TextGrid object
}
\description{
Repairs problem of continuity of T2 and T1 in interval tiers. This
problem is very rare and it should not appear. However, e.g.,
automatic segmentation tool Prague Labeller produces random numeric
round-up errors featuring, e.g., T2 of preceding interval is slightly
higher than the T1 of the current interval. Because of that, the boundary
cannot be manually moved in Praat edit window.
}
\examples{
\dontrun{
tgProblem <- tg.sampleProblem()
tgNew <- tg.repairContinuity(tgProblem)
tg.write(tgNew, "demo_problem_OK.TextGrid")
}
}
\seealso{
\code{\link{tg.sampleProblem}}
}
