% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleComposition.R
\name{getSampleComposition}
\alias{getSampleComposition}
\title{Get the cell-type content for each sample from the panglaoDB database.}
\usage{
getSampleComposition(
  sra = "All",
  srs = "All",
  tissue = "All",
  protocol = "All",
  specie = "All",
  verbose = TRUE
)
}
\arguments{
\item{sra}{Filter based on the SRA identifier of the biological sample in the SRA database}

\item{srs}{Filter based on the SRS identifier of the biological sample in the SRA database}

\item{tissue}{Filter based on the tissue from which the biological samples originates from}

\item{protocol}{Filter based on the single-cell library preparation protocol used to generate the data}

\item{specie}{Filter based on the specie from which the biological samples originates from}

\item{verbose}{A boolean value TRUE or FALSE to activate the verbose mode}
}
\value{
This function returns the cell-type composition of the samples included in the PanglaoDB database in a data frame with 8 columns as follows:
\itemize{
\item{SRA:} The SRA identifier of the biological sample in the SRA database
\item{SRS:} The SRS identifier of the biological sample in the SRA database
\item{Tissue:} The tissue from which the biological samples originated from
\item{Protocol:} The single-cell library preparation protocol used to generate the data
\item{Species:} The species from which the biological samples originated from
\item{Cluster:}  The cluster-id assigned by the panglaoDB database to the cells in the sample
\item{Cells:} The number of cells included in the cluster
\item{Cell Type:} The cell-type from which the counts originates from
}
}
\description{
Get the cell-type content for each sample from the panglaoDB database.
}
\examples{
# From PanglaoDB
# https://panglaodb.se/list_clusters_and_cell_types.html?sra=SRA689041&srs=SRS3166675

SRS3166675 <- getSampleComposition(srs = 'SRS3166675')
head(SRS3166675)

#       SRA        SRS Tissue     Protocol      Species Cluster Cells           Cell Type
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       0   735         Fibroblasts
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       1   526 Smooth muscle cells
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       2   465             Unknown
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       3   157             Unknown
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       4   140        Goblet cells
# SRA689041 SRS3166675  Colon 10x chromium Mus musculus       5   100         Fibroblasts
}
