// Generated by rstantools.  Do not edit by hand.

/*
    rPBK is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rPBK is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rPBK.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_export_interpolate_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'export_interpolate', line 65, column 2 to column 9)",
                                                      " (in 'export_interpolate', line 66, column 2 to column 31)",
                                                      " (in 'export_interpolate', line 55, column 2 to column 9)",
                                                      " (in 'export_interpolate', line 56, column 2 to column 8)",
                                                      " (in 'export_interpolate', line 57, column 9 to column 10)",
                                                      " (in 'export_interpolate', line 57, column 2 to column 16)",
                                                      " (in 'export_interpolate', line 58, column 9 to column 10)",
                                                      " (in 'export_interpolate', line 58, column 2 to column 16)",
                                                      " (in 'export_interpolate', line 4, column 2 to column 13)",
                                                      " (in 'export_interpolate', line 12, column 6 to column 15)",
                                                      " (in 'export_interpolate', line 11, column 24 to line 13, column 5)",
                                                      " (in 'export_interpolate', line 11, column 4 to line 13, column 5)",
                                                      " (in 'export_interpolate', line 14, column 4 to column 14)",
                                                      " (in 'export_interpolate', line 10, column 9 to line 15, column 3)",
                                                      " (in 'export_interpolate', line 9, column 4 to column 14)",
                                                      " (in 'export_interpolate', line 8, column 39 to line 10, column 3)",
                                                      " (in 'export_interpolate', line 8, column 9 to line 15, column 3)",
                                                      " (in 'export_interpolate', line 6, column 4 to column 30)",
                                                      " (in 'export_interpolate', line 7, column 4 to column 14)",
                                                      " (in 'export_interpolate', line 5, column 18 to line 8, column 3)",
                                                      " (in 'export_interpolate', line 5, column 2 to line 15, column 3)",
                                                      " (in 'export_interpolate', line 3, column 33 to line 16, column 1)",
                                                      " (in 'export_interpolate', line 23, column 4 to column 16)",
                                                      " (in 'export_interpolate', line 22, column 8 to line 24, column 3)",
                                                      " (in 'export_interpolate', line 20, column 4 to column 33)",
                                                      " (in 'export_interpolate', line 21, column 4 to column 90)",
                                                      " (in 'export_interpolate', line 19, column 36 to line 22, column 3)",
                                                      " (in 'export_interpolate', line 19, column 2 to line 24, column 3)",
                                                      " (in 'export_interpolate', line 18, column 48 to line 25, column 1)",
                                                      " (in 'export_interpolate', line 28, column 9 to column 15)",
                                                      " (in 'export_interpolate', line 28, column 16 to column 22)",
                                                      " (in 'export_interpolate', line 28, column 2 to column 44)",
                                                      " (in 'export_interpolate', line 29, column 9 to column 15)",
                                                      " (in 'export_interpolate', line 29, column 16 to column 22)",
                                                      " (in 'export_interpolate', line 29, column 2 to column 31)",
                                                      " (in 'export_interpolate', line 34, column 6 to column 105)",
                                                      " (in 'export_interpolate', line 33, column 11 to line 35, column 5)",
                                                      " (in 'export_interpolate', line 32, column 6 to column 74)",
                                                      " (in 'export_interpolate', line 31, column 22 to line 33, column 5)",
                                                      " (in 'export_interpolate', line 31, column 4 to line 35, column 5)",
                                                      " (in 'export_interpolate', line 30, column 20 to line 36, column 3)",
                                                      " (in 'export_interpolate', line 30, column 2 to line 36, column 3)",
                                                      " (in 'export_interpolate', line 37, column 2 to column 20)",
                                                      " (in 'export_interpolate', line 27, column 107 to line 38, column 1)",
                                                      " (in 'export_interpolate', line 42, column 9 to column 12)",
                                                      " (in 'export_interpolate', line 42, column 14 to column 17)",
                                                      " (in 'export_interpolate', line 42, column 2 to column 55)",
                                                      " (in 'export_interpolate', line 43, column 9 to column 12)",
                                                      " (in 'export_interpolate', line 43, column 2 to column 53)",
                                                      " (in 'export_interpolate', line 44, column 9 to column 12)",
                                                      " (in 'export_interpolate', line 44, column 14 to column 17)",
                                                      " (in 'export_interpolate', line 44, column 2 to column 55)",
                                                      " (in 'export_interpolate', line 46, column 2 to column 24)",
                                                      " (in 'export_interpolate', line 40, column 45 to line 47, column 1)",
                                                      " (in 'export_interpolate', line 50, column 9 to column 10)",
                                                      " (in 'export_interpolate', line 50, column 11 to column 12)",
                                                      " (in 'export_interpolate', line 50, column 2 to column 52)",
                                                      " (in 'export_interpolate', line 51, column 2 to column 12)",
                                                      " (in 'export_interpolate', line 49, column 22 to line 52, column 1)"};
template <typename T0__, typename T1__>
int
findfirst(const T0__& t, const T1__& xt_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>>;
  const auto& xt = to_ref(xt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int i;
    i = std::numeric_limits<int>::min();
    
    current_statement__ = 9;
    i = 0;
    current_statement__ = 21;
    if (logical_eq(t, max(xt))) {
      current_statement__ = 18;
      i = (num_elements(xt) - 1);
      current_statement__ = 19;
      return i;
    } else {
      current_statement__ = 17;
      if ((primitive_value(logical_lt(t, min(xt))) || primitive_value(
          logical_gt(t, max(xt))))) {
        current_statement__ = 15;
        return i;
      } else {
        current_statement__ = 12;
        while (logical_gte(t, xt[((i + 1) - 1)])) {
          current_statement__ = 10;
          i = (i + 1);
        }
        current_statement__ = 13;
        return i;
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct findfirst_functor__ {
template <typename T0__, typename T1__>
int
operator()(const T0__& t, const T1__& xt, std::ostream* pstream__)  const 
{
return findfirst(t, xt, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
interpolate(const T0__& x, const T1__& xpt_arg__, const T2__& ypt_arg__,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>>;
  const auto& xpt = to_ref(xpt_arg__);
  const auto& ypt = to_ref(ypt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 28;
    if ((primitive_value(logical_gte(x, min(xpt))) && primitive_value(
        logical_lte(x, max(xpt))))) {
      int idx;
      idx = std::numeric_limits<int>::min();
      
      current_statement__ = 25;
      idx = findfirst(x, xpt, pstream__);
      current_statement__ = 26;
      return (ypt[(idx - 1)] +
               (((x - xpt[(idx - 1)]) *
                  (ypt[((idx + 1) - 1)] - ypt[(idx - 1)])) /
                 (xpt[((idx + 1) - 1)] - xpt[(idx - 1)])));
    } else {
      current_statement__ = 23;
      return 0.0;
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct interpolate_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
operator()(const T0__& x, const T1__& xpt, const T2__& ypt,
           std::ostream* pstream__)  const 
{
return interpolate(x, xpt, ypt, pstream__);
}
};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<T7__>>, -1, -1>
exact_AD_long(const T0__& time_arg__, const int& N_time, const T2__& tacc,
              const T3__& E_arg__, const T4__& I_arg__, const T5__& U_arg__,
              const int& N_comp, const T7__& Cx, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T2__,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>,
          stan::value_type_t<T5__>, stan::promote_args_t<T7__>>;
  const auto& time = to_ref(time_arg__);
  const auto& E = to_ref(E_arg__);
  const auto& I = to_ref(I_arg__);
  const auto& U = to_ref(U_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 30;
    validate_non_negative_index("E_inv", "N_comp", N_comp);
    current_statement__ = 31;
    validate_non_negative_index("E_inv", "N_comp", N_comp);
    Eigen::Matrix<local_scalar_t__, -1, -1> E_inv;
    E_inv = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_comp);
    stan::math::fill(E_inv, DUMMY_VAR__);
    
    current_statement__ = 32;
    assign(E_inv, nil_index_list(), inverse(E), "assigning variable E_inv");
    current_statement__ = 33;
    validate_non_negative_index("E_out", "N_comp", N_comp);
    current_statement__ = 34;
    validate_non_negative_index("E_out", "N_time", N_time);
    Eigen::Matrix<local_scalar_t__, -1, -1> E_out;
    E_out = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_time);
    stan::math::fill(E_out, DUMMY_VAR__);
    
    current_statement__ = 42;
    for (int i = 1; i <= N_time; ++i) {
      current_statement__ = 40;
      if (logical_lt(time[(i - 1)], tacc)) {
        current_statement__ = 38;
        assign(E_out,
          cons_list(index_min_max(1, N_comp),
            cons_list(index_uni(i), nil_index_list())),
          multiply(
            multiply(
              multiply(E_inv,
                subtract(matrix_exp(multiply(time[(i - 1)], E)), I)), U), Cx),
          "assigning variable E_out");
      } else {
        current_statement__ = 36;
        assign(E_out,
          cons_list(index_min_max(1, N_comp),
            cons_list(index_uni(i), nil_index_list())),
          multiply(
            multiply(
              multiply(E_inv,
                subtract(matrix_exp(multiply(time[(i - 1)], E)),
                  matrix_exp(multiply((time[(i - 1)] - tacc), E)))), U), Cx),
          "assigning variable E_out");
      }}
    current_statement__ = 43;
    return transpose(E_out);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct exact_AD_long_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<T7__>>, -1, -1>
operator()(const T0__& time, const int& N_time, const T2__& tacc,
           const T3__& E, const T4__& I, const T5__& U, const int& N_comp,
           const T7__& Cx, std::ostream* pstream__)  const 
{
return exact_AD_long(time, N_time, tacc, E, I, U, N_comp, Cx, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, -1>
matrix_E(const T0__& ke_arg__, const T1__& k_arg__, const int& N_k,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& ke = to_ref(ke_arg__);
  const auto& k = to_ref(k_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 45;
    validate_non_negative_index("m", "N_k", N_k);
    current_statement__ = 46;
    validate_non_negative_index("m", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, -1> m;
    m = Eigen::Matrix<local_scalar_t__, -1, -1>(N_k, N_k);
    stan::math::fill(m, DUMMY_VAR__);
    
    current_statement__ = 47;
    assign(m, nil_index_list(), add_diag(k, rep_vector(0, N_k)),
      "assigning variable m");
    current_statement__ = 48;
    validate_non_negative_index("diag_k", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, 1> diag_k;
    diag_k = Eigen::Matrix<local_scalar_t__, -1, 1>(N_k);
    stan::math::fill(diag_k, DUMMY_VAR__);
    
    current_statement__ = 49;
    assign(diag_k, nil_index_list(),
      subtract(minus(ke), multiply(m, rep_vector(1, N_k))),
      "assigning variable diag_k");
    current_statement__ = 50;
    validate_non_negative_index("matrix_E_rtn", "N_k", N_k);
    current_statement__ = 51;
    validate_non_negative_index("matrix_E_rtn", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, -1> matrix_E_rtn;
    matrix_E_rtn = Eigen::Matrix<local_scalar_t__, -1, -1>(N_k, N_k);
    stan::math::fill(matrix_E_rtn, DUMMY_VAR__);
    
    current_statement__ = 52;
    assign(matrix_E_rtn, nil_index_list(), add_diag(k, diag_k),
      "assigning variable matrix_E_rtn");
    current_statement__ = 53;
    return matrix_E_rtn;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct matrix_E_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, -1>
operator()(const T0__& ke, const T1__& k, const int& N_k,
           std::ostream* pstream__)  const 
{
return matrix_E(ke, k, N_k, pstream__);
}
};
Eigen::Matrix<double, -1, -1>
matrix_I(const int& k, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 55;
    validate_non_negative_index("I", "k", k);
    current_statement__ = 56;
    validate_non_negative_index("I", "k", k);
    Eigen::Matrix<local_scalar_t__, -1, -1> I;
    I = Eigen::Matrix<local_scalar_t__, -1, -1>(k, k);
    stan::math::fill(I, DUMMY_VAR__);
    
    current_statement__ = 57;
    assign(I, nil_index_list(), add_diag(rep_matrix(0, k, k), 1),
      "assigning variable I");
    current_statement__ = 58;
    return I;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct matrix_I_functor__ {
Eigen::Matrix<double, -1, -1>
operator()(const int& k, std::ostream* pstream__)  const 
{
return matrix_I(k, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_export_interpolate final : public model_base_crtp<model_export_interpolate> {
private:
  double x;
  int N;
  Eigen::Matrix<double, -1, 1> xpt;
  Eigen::Matrix<double, -1, 1> ypt;
 
public:
  ~model_export_interpolate() { }
  
  inline std::string model_name() const final { return "model_export_interpolate"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_export_interpolate(stan::io::var_context& context__,
                           unsigned int random_seed__ = 0,
                           std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_export_interpolate_namespace::model_export_interpolate";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 3;
      context__.validate_dims("data initialization","x","double",
          context__.to_vec());
      x = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      x = context__.vals_r("x")[(1 - 1)];
      current_statement__ = 4;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 4;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 5;
      validate_non_negative_index("xpt", "N", N);
      current_statement__ = 6;
      context__.validate_dims("data initialization","xpt","double",
          context__.to_vec(N));
      xpt = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(xpt, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xpt_flat__;
        current_statement__ = 6;
        assign(xpt_flat__, nil_index_list(), context__.vals_r("xpt"),
          "assigning variable xpt_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 6;
          assign(xpt, cons_list(index_uni(sym1__), nil_index_list()),
            xpt_flat__[(pos__ - 1)], "assigning variable xpt");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 7;
      validate_non_negative_index("ypt", "N", N);
      current_statement__ = 8;
      context__.validate_dims("data initialization","ypt","double",
          context__.to_vec(N));
      ypt = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(ypt, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> ypt_flat__;
        current_statement__ = 8;
        assign(ypt_flat__, nil_index_list(), context__.vals_r("ypt"),
          "assigning variable ypt_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 8;
          assign(ypt, cons_list(index_uni(sym1__), nil_index_list()),
            ypt_flat__[(pos__ - 1)], "assigning variable ypt");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_export_interpolate_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_export_interpolate_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      double y;
      y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      y = interpolate(x, xpt, ypt, pstream__);
      vars__.emplace_back(y);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("y");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "y");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "y");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"y\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"y\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_export_interpolate_namespace::model_export_interpolate;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_export_interpolate_namespace::profiles__;
}
#endif
#endif
