\name{rMR-package}
\alias{rMR-package}
\alias{rMR}
\docType{package}
\title{
Importing Data from Loligo Systems Software Output, Calculating Metabolic Rates, and Critical Tensions
}
\description{
Analysis of oxygen consumption data generated by Loligo (R) Systems respirometry equipment. The package includes a function for loading data output by Loligo's 'AutoResp' software (get.witrox.data()), functions for calculating metabolic rates over user-specified time intervals, extracting critical points from data using broken stick regressions based on Yeager and Ultsch (1989), and easy functions for converting between different units of barometric pressure.
}
\details{
\tabular{ll}{
Package: \tab rMR\cr
Type: \tab Package\cr
Version: \tab 1.0.3\cr
Date: \tab 2017-01-05\cr
License: \tab 3\cr
}
}
\author{
Tyler L. Moulton

Maintainer: Tyler L. Moulton <tyler.moulton@mail.mcgill.ca>

}
\references{
Benson, B.B., and Daniel Krause, Jr (1980). The concentration and isotopic fractionation of gases dissolved in freshwater in equilibrium with the atmosphere. 1. Oxygen: Limnology and Oceanography, vol. 25, no. 4, p. 662-671. \doi{10.4319/lo.1980.25.4.0662}.

Gnaiger, Erich, and Hellmuth Forstner, eds. (2012). Polarographic oxygen sensors: Aquatic and physiological applications. Springer Science & Business Media. \doi{10.1007/978-3-642-81863-9}.

Lumley, Thomas (2013). "biglm: bounded memory linear and generalized linear models". 0.9-1. \url{https://CRAN.R-project.org/package=biglm}.

McDonnell, Laura H., and Lauren J. Chapman (2016). "Effects of thermal increase on aerobic capacity and swim performance in a tropical inland fish." Comparative Biochemistry and Physiology Part A: Molecular & Integrative Physiology 199: 62-70. \doi{10.1016/j.cbpa.2016.05.018}.

Mechtly, E. A. (1973). The International System of Units, Physical Constants and Conversion Factors. NASA SP-7012, Second Revision, National Aeronautics and Space Administration, Washington, D.C. \url{https://ntrs.nasa.gov/archive/nasa/casi.ntrs.nasa.gov/19730018242.pdf}.

Roche, Dominique G., et al. (2013). "Finding the best estimates of metabolic rates in a coral reef fish." Journal of Experimental Biology 216.11: 2103-2110. \doi{10.1242/jeb.082925}.

U.S. Geological Survey (2011). Change to solubility equations for oxygen in water: Office of Water Quality Technical Memorandum 2011.03, accessed July 15, 2011, at \url{http://water.usgs.gov/admin/memo/QW/qw11.03.pdf}.

Yeager, D. P. and Ultsch, G. R. (1989). Physiological regulation and conformation: a BASIC program for the determination of critical points. Physiological Zoology, 888-907. \doi{10.1086/physzool.62.4.30157935}.

http://www.loligosystems.com/


}
\keyword{ package }
\seealso{
\code{\link{biglm}}
}

