% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.data.R
\name{load.bathy}
\alias{load.bathy}
\title{Import lake bathymetry data.}
\usage{
load.bathy(fPath)
}
\arguments{
\item{fPath}{File path to the bathymetry file.}
}
\value{
data.frame of depth and area for given lake.
}
\description{
Imports lake bathymetry data. Bathymetric data file must be a 2 column array
where depth (in meters) and area (in meters^2) information are provided in
columns with headers containing the words "depths" and "areas" respectively.
}
\examples{

  #Get the path for the package example file included
  exampleFilePath <- system.file('extdata', 'Sparkling.bth', package="rLakeAnalyzer")
  
  #Load and plot the hypsometric curve
  sparkling.bathy = load.bathy(exampleFilePath)
  
  #If successful, there will be two colums. "depths", and "areas".
  plot(sparkling.bathy$areas, sparkling.bathy$depths, type='l', ylim=c(20,0), 
    ylab='Depths (m)', xlab='Areas (m^2)')
  
}
\seealso{
\code{\link{load.ts}}
}
\keyword{file}
