% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FTRLProx_validate_spMatrix}
\alias{FTRLProx_validate_spMatrix}
\title{FTRL-Proximal Linear Model Validation Function}
\usage{
FTRLProx_validate_spMatrix(x, y, family, params, epoch, val_x, val_y, eval,
  verbose)
}
\arguments{
\item{x}{a transposed \code{dgCMatrix}.}

\item{y}{a vector containing labels.}

\item{family}{link function to be used in the model. "gaussian", "binomial" and "poisson" are avaliable.}

\item{params}{a list of parameters of FTRL-Proximal Algorithm.
\itemize{
  \item \code{alpha} alpha in the per-coordinate learning rate
  \item \code{beta} beta in the per-coordinate learning rate
  \item \code{l1} L1 regularization parameter
  \item \code{l2} L2 regularization parameter
}}

\item{epoch}{The number of iterations over training data to train the model.}

\item{val_x}{a transposed \code{dgCMatrix} for validation.}

\item{val_y}{a vector containing labels for validation.}

\item{eval}{a evaluation metrics computing function, the first argument shoule be prediction, the second argument shoule be label.}

\item{verbose}{logical value. Indicating if the validation result for each epoch is displayed or not.}
}
\value{
a FTRL-Proximal linear model object
}
\description{
FTRLProx_validate_spMatrix validates the performance of FTRL-Proximal online learning model.
This function is an C++ implementation.
This function is used internally and is not intended for end-user direct usage.
}

