% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{learnItemEmb}
\alias{learnItemEmb}
\title{Machine learning algorithm to learn item representations maximizing log likelihood under DPP assumption.}
\usage{
learnItemEmb(
  train_data_path,
  emb_size,
  regularization,
  learning_rate,
  neg_sample_cnt,
  epoch
)
}
\arguments{
\item{train_data_path}{A string for text file path. Each line: item_id,item_id,item_id}

\item{emb_size}{int. ColumnNum for model parameter. While RowNum = number of uniq items parsed in train_data_path}

\item{regularization}{float. Default = 0.1}

\item{learning_rate}{float. Generally begin with small learning_rate will train better.}

\item{neg_sample_cnt}{int.}

\item{epoch}{int.}
}
\value{
A list contains 1) learned item embedding matrix; 2) item names vector; 3) log likelihood on each training step vector.
}
\description{
Machine learning algorithm to learn item representations maximizing log likelihood under DPP assumption.
}
\examples{
library(rDppDiversity)
data_path=system.file("extdata", "data.txt", package = "rDppDiversity")
learnItemEmb(data_path, 3, 0.1, 0.01, 0, 10)
}
