% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_AmBalloon.R
\docType{methods}
\name{initialize,AmBalloon-method}
\alias{initialize,AmBalloon-method}
\alias{amBalloon}
\alias{setAdjustBorderColor}
\alias{setAdjustBorderColor,AmBalloon,logical-method}
\alias{setColor}
\alias{setColor,AmBalloon,character-method}
\alias{setCornerRadius}
\alias{setCornerRadius,AmBalloon,numeric-method}
\alias{setFillColor}
\alias{setFillColor,AmBalloon,character-method}
\title{Initializes an AmBalloon}
\usage{
\S4method{initialize}{AmBalloon}(.Object, adjustBorderColor, color,
  cornerRadius, fillColor, ...)

amBalloon(adjustBorderColor, color, cornerRadius, fillColor, ...)

setAdjustBorderColor(.Object, adjustBorderColor)

\S4method{setAdjustBorderColor}{AmBalloon,logical}(.Object, adjustBorderColor)

setColor(.Object, color)

\S4method{setColor}{AmBalloon,character}(.Object, color)

setCornerRadius(.Object, cornerRadius)

\S4method{setCornerRadius}{AmBalloon,numeric}(.Object, cornerRadius)

setFillColor(.Object, fillColor)

\S4method{setFillColor}{AmBalloon,character}(.Object, fillColor)
}
\arguments{
\item{.Object}{\linkS4class{AmBalloon}.}

\item{adjustBorderColor}{\code{logical}, 
if TRUE, border color will be changed when user rolls-over the slice, graph, 
etc, instead of background color.}

\item{color}{\code{character}, 
balloon text color.}

\item{cornerRadius}{\code{numeric}, 
balloon corner radius.}

\item{fillColor}{\code{character}, 
balloon background color. It is usually defined by the chart itself. If
"adjustBorderColor" is set to TRUE, the balloon background color will be
equal to "fillColor".}

\item{...}{other properties of AmBalloon.
See \url{http://docs.amcharts.com/3/javascriptcharts/AmBalloon}.}
}
\value{
An object, possibly updated,  of class \linkS4class{AmBalloon}.
}
\description{
Initializes or updates an object \linkS4class{AmBalloon}.
}
\examples{

new("AmBalloon", cornerRadius = 10)

amBalloon(adjustBorderColor = TRUE, color = "#000000", other = TRUE)

setAdjustBorderColor(.Object = amBalloon(), adjustBorderColor = TRUE)

setColor(.Object = amBalloon(), color = "#000000")

setCornerRadius(.Object = amBalloon(), cornerRadius = 5)

setFillColor(.Object = amBalloon(), fillColor = "#FFFFFF")

}
