% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_test.R
\name{sign_test}
\alias{sign_test}
\alias{to_SPSS.sign_test_SPSS}
\alias{print.sign_test_SPSS}
\alias{signTest}
\title{Sign Test}
\usage{
sign_test(data, variables, exact = FALSE)

\method{to_SPSS}{sign_test_SPSS}(
  object,
  statistics = c("test", "frequencies"),
  version = r2spss_options$get("version"),
  ...
)

\method{print}{sign_test_SPSS}(
  x,
  statistics = c("frequencies", "test"),
  version = r2spss_options$get("version"),
  ...
)

signTest(data, variables, exact = FALSE)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying two numeric variables
containing the paired observations.}

\item{exact}{a logical indicating whether or not to include the exact
p-value using the binomial distribution.  Note that the p-value using the
normal approximation is always reported.}

\item{object, x}{an object of class \code{"sign_test_SPSS"} as returned by
function \code{sign_test}.}

\item{statistics}{a character string or vector specifying which SPSS tables
to produce.   Available options are \code{"frequencies"} for a summary of
the frequencies and \code{"test"} for test results.  For the \code{to_SPSS}
method, only one option is allowed (the default is the table of test
results), but the \code{print} method allows several options (the default
is to print all tables).}

\item{version}{a character string specifying whether the table should
mimic the content and look of recent SPSS versions (\code{"modern"}) or
older versions (<24; \code{"legacy"}).  The main difference in terms of
content is that small p-values are displayed differently.}

\item{\dots}{additional arguments to be passed down to
\code{\link{format_SPSS}}.}
}
\value{
An object of class \code{"sign_test_SPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing information on the
  number of observations with negative and positive differences.}
  \item{\code{asymptotic}}{a list containing the results of the test using
  the normal approximation.}
  \item{\code{exact}}{if requested, a numeric vector containing the exact
  two-sided p-value, one-sided p-value, and point probability using the
  binomial distribution.}
  \item{\code{variables}}{a character vector containing the names of the two
  numeric variables with the paired observations.}
  \item{\code{n}}{an integer giving the number of observations.}
}

The \code{to_SPSS} method returns an object of class \code{"SPSS_table"}
which contains all relevant information in the required format to produce
the LaTeX table.  See \code{\link{to_latex}} for possible components and
how to further customize the LaTeX table based on the returned object.

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output.
}
\description{
Perform a sign test for a paired sample on variables of a data set.  The
output is printed as a LaTeX table that mimics the look of SPSS output.
}
\details{
The \code{print} method first calls the \code{to_SPSS} method followed
by \code{\link{to_latex}}.  Further customization can be done by calling
those two functions separately, and modifying the object returned by
\code{to_SPSS}.
}
\note{
LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
# load data
data("Exams")

# test whether grades differ between the
# regular exam and the resit
sign_test(Exams, c("Regular", "Resit"))

}
\author{
Andreas Alfons
}
\keyword{htest}
