% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_text.R
\name{rtf_text}
\alias{rtf_text}
\title{Text to RTF Encode}
\usage{
rtf_text(
  text,
  font = 1,
  font_size = 12,
  format = NULL,
  color = NULL,
  background_color = NULL,
  text_convert = TRUE
)
}
\arguments{
\item{text}{Plain text.}

\item{font}{Text font type.}

\item{font_size}{Text font size.}

\item{format}{Text format.}

\item{color}{Text color.}

\item{background_color}{Text background color.}

\item{text_convert}{A logical value to convert special characters. Default is TRUE.}
}
\description{
Text to RTF Encode
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Set font color default value to black if background color value is not NULL and color value is NULL.
   \item Validate if input font type is valid using \code{font_type()}.
   \item Validate if input font format is valid using \code{font_format()}.
   \item Validate if input table color is valid using \code{color_table()}.
   \item Convert latex character to Unicode using \code{convert()}.
   \item Add left curly bracket to start of code and right curly bracket to the end of code.
   \item Combine all components into a single code string.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

